/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.TerminalSeguro;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.Date;

public class MicVerificaInicioDia {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String CONFIG_MANUAL = "CONFIG_MANUAL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) {
        block15: {
            ControladorInicioDia controladorInicioDia = null;
            ControladorConfCTFClient controladorConfCTFClient = null;
            ConfCTFClient config = null;
            DadosInicioDia dadosInicioDia = null;
            IdentTerminal identTerminal = null;
            try {
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                if (entradaIntegracao != null && (entradaIntegracao.getOperacao() == 800 || entradaIntegracao.getOperacao() == 908)) {
                    return NOT_REQUIRED;
                }
                controladorConfCTFClient = ControladorConfCTFClient.getInstance();
                config = controladorConfCTFClient.getConfig();
                controladorInicioDia = ControladorInicioDia.getInstance();
                EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
                boolean delivery = entradaApiTefC.getIdentificacaoTransacao() == 1;
                boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
                boolean multiEC = config.isMultiEC();
                identTerminal = Contexto.getContexto().getEntradaIntegracao() != null && (multiTerminal || delivery || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    boolean inicioDiaNaoRequerido = false;
                    if (Contexto.getContexto().getEntradaIntegracao().getNumeroTransacao() != 1) {
                        inicioDiaNaoRequerido = true;
                    } else if (Contexto.getContexto().getEntradaIntegracao().getOperacao() == 6 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 7 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 800) {
                        inicioDiaNaoRequerido = true;
                    }
                    if (inicioDiaNaoRequerido && !config.isIntegracaoWeb()) {
                        ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(dadosInicioDia.getTipoBibliotecaPinpad());
                        this.preencheTerminalSeguro(dadosInicioDia, config);
                        return NOT_REQUIRED;
                    }
                }
                if (dadosInicioDia == null || dadosInicioDia.getDataInicioDia() == null) {
                    if (!config.isStandAlone()) {
                        this.logger.warn("##########################################################");
                        this.logger.warn("#  CTFClient configurado para Inicio dia Manual. \t\t  #");
                        this.logger.warn("#  N\u00e3o foi poss\u00edvel carregar o arquivo de inicializa\u00e7\u00e3o. #");
                        this.logger.warn("##########################################################");
                    }
                    return REQUIRED;
                }
                if (!config.isIntegracaoWeb()) {
                    ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(dadosInicioDia.getTipoBibliotecaPinpad());
                    this.preencheTerminalSeguro(dadosInicioDia, config);
                }
                if (config.isStandAlone()) {
                    if (!dadosInicioDia.equalsData(new Date())) {
                        return REQUIRED;
                    }
                    break block15;
                }
                return CONFIG_MANUAL;
            }
            catch (ExcecaoApiAc e) {
                this.logger.warn("n\u00e3o foi poss\u00edvel carregar o arquivo de controle inicio dia para o terminal " + identTerminal);
                if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getOperacao() == 800) {
                    return NOT_REQUIRED;
                }
                if (!config.isStandAlone()) {
                    this.logger.warn("##########################################################");
                    this.logger.warn("#  CTFClient configurado para Inicio dia Manual.         #");
                    this.logger.warn("#  N\u00e3o foi poss\u00edvel carregar o arquivo de inicializa\u00e7\u00e3o. #");
                    this.logger.warn("##########################################################");
                }
                return REQUIRED;
            }
        }
        return NOT_REQUIRED;
    }

    private void preencheTerminalSeguro(DadosInicioDia dadosInicioDia, ConfCTFClient config) {
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().getOperacao() == 174 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 173 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 283 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 232 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 233 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 234) {
                ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(false);
            } else {
                ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(config.isComunicacaoSeguraPinpad());
            }
        }
        if (dadosInicioDia != null && dadosInicioDia.getTerminalSeguro() != null) {
            this.logger.debug("Habilitando Terminal seguro");
            TerminalSeguro terminalSeguro = dadosInicioDia.getTerminalSeguro();
            KeyFactory.configureKey(terminalSeguro.getIndiceChave(), terminalSeguro.getModuloChave(), terminalSeguro.getExponenteChave());
            Contexto.getContexto().getEntradaApiTefC().setIndiceChaveTerminal(KeyFactory.getIndiceChave());
        }
    }
}

