/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class ControladorInicioDia {
    private static ControladorInicioDia controladorInicioDia;
    private final String PERSISTENCE_FILE = "InicioDia.dat";
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;

    private ControladorInicioDia() {
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    public static synchronized ControladorInicioDia getInstance() {
        if (controladorInicioDia == null) {
            controladorInicioDia = new ControladorInicioDia();
        }
        return controladorInicioDia;
    }

    private String formatPathName(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String path = "";
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/" : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
        return path;
    }

    private String formatPath(IdentTerminal identTerminal) throws ExcecaoApiAc {
        return this.formatPathName(identTerminal) + File.separator + "InicioDia.dat";
    }

    public synchronized void persistirDadosInicioDia(IdentTerminal identTerminal, Object obj) throws ExcecaoApiAc {
        String path = this.formatPath(identTerminal);
        this.createPath(path);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(path));
            output.writeObject(obj);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoApiAc(null, "Erro ao gravar arquivo", "", e);
        }
    }

    public DadosInicioDia getDadosInicioDia(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal);
        DadosInicioDia obj = null;
        try {
            ObjectInputStream input = null;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                fileInput.close();
                File file = new File(name);
                file.exists();
                throw new ExcecaoApiAc(null, "LOAD", "ARQUIVO CORROMPIDO", e);
            }
            try {
                obj = (DadosInicioDia)input.readObject();
            }
            catch (ClassNotFoundException e) {
                input.close();
                fileInput.close();
                throw new ExcecaoApiAc("CMOS00", "LOAD", "CLASSNOTFOUND", e);
            }
            finally {
                if (input != null) {
                    input.close();
                }
                if (fileInput != null) {
                    fileInput.close();
                }
            }
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("CMOS00", "ERRO", "ERRO_FILE", e);
        }
        return obj;
    }

    public void remove(IdentTerminal key) throws ExcecaoApiAc {
        String name = this.formatPath(key);
        File file = new File(name);
        file.delete();
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf(File.separator) != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf(File.separator)))).exists()) {
            arquivo.mkdirs();
        }
    }

    static {
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
    }
}

