/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.ApitefDefault;
import com.csi.ctfclient.apitef.ApitefJNA;
import com.csi.ctfclient.apitef.ApitefJNI;
import com.csi.ctfclient.apitef.model.ContingenciaConexao;
import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfContingenciaConexao;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.ArrayList;

public class ControladorApitefC {
    private static final ILogger log = CTFClientLogger.getCTFClient();

    public static Apitef newInstancia() {
        try {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            ApitefDefault apitef = null;
            apitef = config.isIntegracaoAndroid() ? new ApitefJNI("C030201" + ControladorConfCTFClient.VERSAO_CLIENT_DRAFT, config.getTimeOutDefault(), config.getConfTraceApiwebctf().isHabilitado(), config.getConfTraceApiwebctf().getQtdDias(), ControladorConfCTFClient.getDiretorioTrabalho()) : new ApitefJNA("C030201" + ControladorConfCTFClient.VERSAO_CLIENT_DRAFT, config.getTimeOutDefault(), config.getConfTraceApiwebctf().isHabilitado(), config.getConfTraceApiwebctf().getQtdDias(), null);
            apitef.setVersaoCielo("C0212".substring(0, 5));
            apitef.setVersaoEspecificacaoRedecard("L0602");
            apitef.setVersaoClientRedecard("C0138");
            apitef.setPingUDP(config.isPingUDP());
            apitef.setVersaoPathTerminal(config.getVersaoPathTerminal());
            if (config.getConfContingenciaConexao() != null) {
                ConfContingenciaConexao contingenciaConexao = config.getConfContingenciaConexao();
                ContingenciaConexao contingencia = new ContingenciaConexao();
                if (contingenciaConexao.isMaximoConexao()) {
                    contingencia.setMaximoConexao(contingenciaConexao.getMaximoConexao());
                }
                if (contingenciaConexao.isTempoMaximoConexao()) {
                    contingencia.setTempoMaximoConexao(contingenciaConexao.getTempoMaximoConexao());
                }
                if (contingenciaConexao.isResetConexao()) {
                    contingencia.setResetConexao(contingenciaConexao.getResetConexao());
                }
                apitef.setContingenciaConexao(contingencia);
            }
            if (config.getComunicacaoCTF() != null && config.getComunicacaoCTF().length > 0) {
                apitef.setComunicacaoCTF(config.getComunicacaoCTF());
                if (config.getCertificadoHttps() != null) {
                    apitef.setCertificadoHttps(config.getCertificadoHttps());
                }
                if (config.getTokenTerminal() != null) {
                    apitef.setTokenTerminal(config.getTokenTerminal());
                }
            } else {
                boolean hostHttp = false;
                if (config.getIps() != null && config.getIps().size() > 0) {
                    ArrayList<String> listaIPs = new ArrayList<String>();
                    for (ServicoCTF servicoCTF : config.getIps()) {
                        String comunicacao = "6022" + StringUtil.completaString(servicoCTF.getHost().getEndereco().length() + "", 4, '0', true) + servicoCTF.getHost().getEndereco();
                        comunicacao = comunicacao + "6023" + StringUtil.completaString(servicoCTF.getIdentificadorServico().length() + "", 4, '0', true) + servicoCTF.getIdentificadorServico();
                        comunicacao = comunicacao + "60240001" + servicoCTF.getCodigoProtocolo();
                        if (!hostHttp && servicoCTF.getProtocolo().contains("HTTP")) {
                            hostHttp = true;
                        }
                        listaIPs.add(comunicacao);
                    }
                    apitef.setComunicacaoCTF(listaIPs.toArray(new String[0]));
                }
                if (hostHttp) {
                    if (!config.isSuporteHttps() && hostHttp) {
                        log.warn("parametro suporteHttps desabilitado -> host https encontrado na lista de ips. suporteHttps sera habilitado.");
                    }
                    AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
                    try {
                        DadosAutenticacao dadosAutenticacao = autenticacaoUtil.getDadosAutenticacao();
                        String token = null;
                        token = dadosAutenticacao != null ? dadosAutenticacao.getToken() : autenticacaoUtil.getTokenAutorizacao();
                        if (token == null) {
                            log.error("token de autenticacao invalido. realize nova autenticacao.");
                            apitef.setComunicacaoCTF(null);
                            throw new Exception("Token invalio.");
                        }
                        apitef.setTokenTerminal(token);
                        String path = "ca-bundle.crt";
                        if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                            path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
                        }
                        apitef.setCertificadoHttps(path);
                    }
                    catch (Exception e) {
                        log.error("nao foi possivel recuperar os dados de autorizacao do terminal. " + e.getMessage());
                    }
                }
            }
            if (config.isIntegracaoWeb()) {
                apitef.setIdentificacaoTransacao(2);
            } else if (config.isIntegracaoAndroid()) {
                apitef.setIdentificacaoTransacao(4);
            } else {
                apitef.setIdentificacaoTransacao(0);
            }
            if (config.isMultiEC()) {
                apitef.setMultiEC(config.isMultiEC());
                apitef.setCodigoGrupoMultiEC(config.getCodigoGrupoMultiEC());
            }
            return apitef;
        }
        catch (ExcecaoApiAc e) {
            throw new RuntimeException(e);
        }
    }
}

