/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class ControladorPersistencia {
    private static ControladorPersistencia controladorPersistencia;
    private final String DEFAULT_PERSISTENCE_FILE = "Controles.dat";
    private static ILogger logger;
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;

    public static synchronized ControladorPersistencia getInstance() {
        if (controladorPersistencia == null) {
            controladorPersistencia = new ControladorPersistencia();
        }
        return controladorPersistencia;
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    private String formatPathName(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String path = "";
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal();
        return path + "/";
    }

    protected String formatPath(IdentTerminal identTerminal) throws ExcecaoApiAc {
        return this.formatPathName(identTerminal) + this.getPersistenceFile();
    }

    protected String getPersistenceFile() {
        return "Controles.dat";
    }

    public synchronized void persistirDados(IdentTerminal identTerminal, DadosPersistencia obj) throws ExcecaoApiAc {
        String path = this.formatPath(identTerminal);
        this.createPath(path);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(path));
            output.writeObject(obj);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoApiAc(null, "Erro ao gravar arquivo", "", e);
        }
    }

    public DadosPersistencia getDadosPersistencia(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal);
        DadosPersistencia obj = null;
        try {
            ObjectInputStream input = null;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                logger.log("WARN", "O arquivo " + name + " est\u00e1 corrompido e ser\u00e1 deletado");
                fileInput.close();
                File file = new File(name);
                if (file.exists()) {
                    logger.log("WARN", name + " deletado " + file.delete());
                }
                throw new ExcecaoApiAc(null, "LOAD", "ARQUIVO CORROMPIDO", e);
            }
            try {
                obj = (DadosPersistencia)input.readObject();
            }
            catch (ClassNotFoundException e) {
                input.close();
                fileInput.close();
                throw new ExcecaoApiAc("CMOS00", "LOAD", "CLASSNOTFOUND", e);
            }
            input.close();
            fileInput.close();
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("CMOS00", "ERRO", "ERRO_FILE", e);
        }
        return obj;
    }

    public void remove(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal);
        File file = new File(name);
        file.delete();
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists()) {
            arquivo.mkdirs();
        }
    }

    static {
        logger = CTFClientLogger.getCTFClient();
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
    }
}

