/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.servicos;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoPrepagoDigital;
import com.csi.ctfclient.apitef.model.ConsultaValoresCreditoDigital;
import com.csi.ctfclient.apitef.model.EstabelecimentoMultiEC;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.apitef.model.ValorRecargaTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.TerminalManager;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessAdesaoSeguro;
import com.csi.ctfclient.operacoes.action.ProcessAlteracaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessAtivacaoSolucaoCerta;
import com.csi.ctfclient.operacoes.action.ProcessAtualizacaoChip;
import com.csi.ctfclient.operacoes.action.ProcessAuto;
import com.csi.ctfclient.operacoes.action.ProcessAutorizacaoIATA;
import com.csi.ctfclient.operacoes.action.ProcessBaixaTecnicaManual;
import com.csi.ctfclient.operacoes.action.ProcessBypass;
import com.csi.ctfclient.operacoes.action.ProcessCancelamento;
import com.csi.ctfclient.operacoes.action.ProcessCancelamentoMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCapturaCredito;
import com.csi.ctfclient.operacoes.action.ProcessCapturaDadosPinpad;
import com.csi.ctfclient.operacoes.action.ProcessCargaProdutosPromocionais;
import com.csi.ctfclient.operacoes.action.ProcessCargaTabelaForcadaTest;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPrepago;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPrepagoDigital;
import com.csi.ctfclient.operacoes.action.ProcessCartaoPresente;
import com.csi.ctfclient.operacoes.action.ProcessCashPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessConfigurarTerminal;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacao;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoDesfazimentoNSUCTF;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacaoWEB;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreVenda;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAnaliticaSpc;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAnaliticaSpcWeb;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvs;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvsMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCartao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCheque;
import com.csi.ctfclient.operacoes.action.ProcessConsultaContaCartao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCredito;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCreditoWeb;
import com.csi.ctfclient.operacoes.action.ProcessConsultaPendencia;
import com.csi.ctfclient.operacoes.action.ProcessConsultaSaldo;
import com.csi.ctfclient.operacoes.action.ProcessConsultaTelefoneCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessConvenioCombustivel;
import com.csi.ctfclient.operacoes.action.ProcessCorrespondenteBancario;
import com.csi.ctfclient.operacoes.action.ProcessCredito;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCelular;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDebito4All;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigitalMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCreditoIATA;
import com.csi.ctfclient.operacoes.action.ProcessCreditoMultiTerminal;
import com.csi.ctfclient.operacoes.action.ProcessCreditoPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessCriptografiaDUKPT;
import com.csi.ctfclient.operacoes.action.ProcessDepositoCartao;
import com.csi.ctfclient.operacoes.action.ProcessDepositoConta;
import com.csi.ctfclient.operacoes.action.ProcessDesbloqueioCartao;
import com.csi.ctfclient.operacoes.action.ProcessDescontoProdutosPromocionais;
import com.csi.ctfclient.operacoes.action.ProcessDesfazimento;
import com.csi.ctfclient.operacoes.action.ProcessDesfazimentoGeral;
import com.csi.ctfclient.operacoes.action.ProcessDotz;
import com.csi.ctfclient.operacoes.action.ProcessECO;
import com.csi.ctfclient.operacoes.action.ProcessEcommerceAutenticado;
import com.csi.ctfclient.operacoes.action.ProcessEmprestimo;
import com.csi.ctfclient.operacoes.action.ProcessEstatisticaManual;
import com.csi.ctfclient.operacoes.action.ProcessFidelidadeMilhas;
import com.csi.ctfclient.operacoes.action.ProcessFuelControl;
import com.csi.ctfclient.operacoes.action.ProcessIdentificacaoAssociado;
import com.csi.ctfclient.operacoes.action.ProcessInicioDia;
import com.csi.ctfclient.operacoes.action.ProcessOperacoesDrogao;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoContas;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoFaturaCartao;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacaoWEB;
import com.csi.ctfclient.operacoes.action.ProcessRecargaCartaoPrePago;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.action.ProcessResgateFacil;
import com.csi.ctfclient.operacoes.action.ProcessResgateFidelidade;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessSaqueCartao;
import com.csi.ctfclient.operacoes.action.ProcessSaqueTransferencia;
import com.csi.ctfclient.operacoes.action.ProcessTefIPFuncoesADM;
import com.csi.ctfclient.operacoes.action.ProcessTefIPOperacoesCheque;
import com.csi.ctfclient.operacoes.action.ProcessTefIPVendaCartao;
import com.csi.ctfclient.operacoes.action.ProcessTefIpEnvioFacil;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesSAA;
import com.csi.ctfclient.operacoes.action.ProcessTrocaSenha;
import com.csi.ctfclient.operacoes.action.ProcessTroco;
import com.csi.ctfclient.operacoes.action.ProcessValeGas;
import com.csi.ctfclient.operacoes.action.ProcessVoucher;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.ICapturaCodigoBarrasPagamento;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.microoperacoes.ProcessUltimoComprovante;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.operacoes.model.controller.IdentificadorMultiECNaoEncontradoException;
import com.csi.ctfclient.operacoes.util.MascaraCartaoUtil;
import com.csi.ctfclient.servicos.CartaoPrepagoDigitalResposta;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.EstabelecimentoMultiECResposta;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.RespostaAtivacaoCartaoPrepago;
import com.csi.ctfclient.servicos.RespostaBypass;
import com.csi.ctfclient.servicos.RespostaCompraCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaAnaliticaSPC;
import com.csi.ctfclient.servicos.RespostaConsultaAvs;
import com.csi.ctfclient.servicos.RespostaConsultaCartaoPrepagoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.servicos.RespostaConsultaTelefoneCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaValoresCreditoDigital;
import com.csi.ctfclient.servicos.RespostaCorrespondenteBancario;
import com.csi.ctfclient.servicos.RespostaOperacaoCheque;
import com.csi.ctfclient.servicos.RespostaPagamentoFaturaCartao;
import com.csi.ctfclient.servicos.RespostaProdutosPromocionais;
import com.csi.ctfclient.servicos.RespostaSimulacaoCrediario;
import com.csi.ctfclient.servicos.RespostaTransacoesSAA;
import com.csi.ctfclient.servicos.RespostaValeGas;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.servicos.TransacaoPendente;
import com.csi.ctfclient.tools.devices.ConfiguracaoPerifericos;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.servico.POSTefServico;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.JPanelLanguage;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CTFClient {
    private static ILogger logger = CTFClientLogger.getCTFClient();
    private static Date dataAtual = null;
    private static CTFClient instance;
    private static ConfiguracaoPerifericos confPerifericos;
    private static ControladorPerifericos controladorPerifericos;
    private static ControladorConfCTFClient controladorConfCTFClient;
    private static TerminalManager terminalManager;
    private ContextoCTFClient searchContexto = null;

    private CTFClient() throws ExcecaoApiAc {
    }

    public static void init() {
        String versao = "C030201-" + ControladorConfCTFClient.VERSAO_CLIENT_DRAFT;
        String versaoCielo = "C0212";
        String versaoRedecard = "C0138";
        String dataVersao = "29/05/2019";
        logger.info("#########################################");
        logger.info("#  Certifica\u00e7\u00e3o Cielo    -> " + versaoCielo + "       #");
        logger.info("#  Certifica\u00e7\u00e3o Redecard -> " + versaoRedecard + "       #");
        logger.info("#  CTFClient vers\u00e3o      -> " + versao + " #");
        logger.info("#  Data vers\u00e3o           -> " + dataVersao + "  #");
        logger.info("#########################################");
    }

    public static synchronized CTFClient getInstancia() throws ExcecaoApiAc {
        if (instance == null) {
            instance = new CTFClient();
            dataAtual = new Date();
            CTFClient.init();
            controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient config = controladorConfCTFClient.getConfig();
            logger.log("INFO", "Carregando estrutura de perifericos");
            confPerifericos = new ConfiguracaoPerifericos(!config.isIntegracaoWeb());
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            if (confPerifericos.isDisplayExterno()) {
                inter.setLanguage(new DisplayFisicoCSILanguage());
            } else {
                inter.setLanguage(new JPanelLanguage());
            }
            logger.log("INFO", "InternacionalizacaoUtil carregada");
            boolean desabilitarDisplay = config.isIntegracaoDll() || config.isIntegracaoWeb() || config.isIntegracaoAndroid();
            controladorPerifericos = new ControladorPerifericos(confPerifericos, desabilitarDisplay);
            logger.log("INFO", "Estrutura de perifericos carregada");
            String path = ControladorConfCTFClient.getDiretorioTrabalho();
            if ("".equals(path)) {
                path = null;
            }
            PersistService.setPathApp(path, config.getVersaoPathTerminal());
            ControladorPersistencia.setPathApp(path, config.getVersaoPathTerminal());
            ControladorInicioDia.setPathApp(path, config.getVersaoPathTerminal());
            if (config.isIntegracaoWeb()) {
                if (config.isControleTerminais()) {
                    terminalManager = TerminalManager.getInstance();
                }
            } else if (config.isIntegracaoAndroid()) {
                CMOSPinPad.setPathApp(ControladorConfCTFClient.getDiretorioTrabalho());
                ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(config.isComunicacaoSeguraPinpad());
            } else {
                ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(config.isComunicacaoSeguraPinpad());
                if (config.getTimeoutPin() != null) {
                    ProtocoloBibliotecaCompartilhada.setTimeoutPin(config.getTimeoutPin().getTimeoutDefault(), config.getTimeoutPin().getTimeoutBlocking(), config.getTimeoutPin().getTimeoutNoblocking());
                }
                if (config.getConfClienteServico() != null && config.getConfClienteServico().isHabilitado()) {
                    POSTef.init(POSTefServico.class);
                    POSTef<?> posMovel = POSTef.getInstance();
                    posMovel.conecta();
                }
            }
            CMOSPinPad.getInstance();
        }
        return instance;
    }

    protected ControladorPerifericos getControladorPerifericos() {
        return controladorPerifericos;
    }

    protected ControladorConfCTFClient getControladorConfCTFClient() {
        return controladorConfCTFClient;
    }

    public void config(ConfCTFClient config) throws ExcecaoApiAc {
        ControladorConfCTFClient.getInstance().save(config);
    }

    public ConfCTFClient getConfig() throws ExcecaoApiAc {
        return ControladorConfCTFClient.getInstance().getConfig();
    }

    public SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada) {
        SaidaCTFClient saida = this.efetuarTransacao(ident, entrada, false, null);
        return saida;
    }

    public SaidaCTFClient efetuarConsulta(IdentTerminal ident, EntradaCTFClient entrada) {
        if (entrada.getOperacao() == 224 || entrada.getOperacao() == 223) {
            SaidaCTFClient saida = this.getSaidaCTFClientErro(20, "5306", new String[]{"OPERACAO  NAO PERMITIDA"}, ident, entrada, false, false);
            logger.warn("consulta n\u00e3o habilitada para essa opera\u00e7\u00e3o.");
            return saida;
        }
        try {
            controladorPerifericos.liberarRecursos(true);
        }
        catch (ExcecaoPerifericos e) {
            logger.error("erro ao liberar recusos");
        }
        return this.efetuarTransacao(ident, entrada, true, null);
    }

    public SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada, long identConsulta) {
        SaidaCTFClient saida = null;
        if (this.searchContexto != null && this.getIdentConsulta(this.searchContexto) == identConsulta) {
            if (this.validaGrupoTransacao(this.searchContexto.getEntradaIntegracao().getOperacao(), entrada.getOperacao())) {
                this.searchContexto.getEntradaApiTefC().setValorTransacao(entrada.getValorTransacao());
                EntradaCTFClientCtrl entradaSearch = this.searchContexto.getEntradaIntegracao();
                if (entradaSearch.getOperacao() == 232 || entradaSearch.getOperacao() == 234 || entradaSearch.getOperacao() == 233) {
                    if (entrada.getOperacao() == 112) {
                        entrada.setOperacao(232);
                    } else if (entrada.getOperacao() == 113) {
                        entrada.setOperacao(233);
                    } else if (entrada.getOperacao() == 114) {
                        entrada.setOperacao(234);
                    }
                }
                logger.info("Transa\u00e7\u00e3o consulta " + this.searchContexto.getEntradaIntegracao().getOperacao() + " setada para " + entrada.getOperacao());
                saida = this.efetuarTransacao(ident, entrada, false, this.searchContexto);
            } else {
                logger.info("Execu\u00e7\u00e3o de transa\u00e7\u00e3o: Entrada difere da consulta");
                saida = this.efetuarTransacao(ident, entrada);
            }
        } else {
            logger.info("Execu\u00e7\u00e3o de transa\u00e7\u00e3o: Identificador da consulta n\u00e3o encontrado");
            if (identConsulta != 0L && "OPE CONSULTA CARTAO".equals(this.searchContexto.getTipoOperacao())) {
                return this.getSaidaCTFClientErro(20, "5365", "IDENTIFICADOR DA CONSULTA NAO ENCONTRADO", ident, entrada, false, false);
            }
            ControladorCriptografia.limparTabelaCriptografia();
            saida = this.efetuarTransacao(ident, entrada);
        }
        return saida;
    }

    /*
     * Exception decompiling
     */
    private SaidaCTFClient efetuarTransacao(IdentTerminal ident, EntradaCTFClient entrada, boolean isConsulta, ContextoCTFClient contextoCTFClient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IdentTerminal configuraTerminalMultiEC(ConfCTFClient conf) {
        IdentTerminal ident = ControladorMultiEC.criarTerminalComumMultiEC(conf.getCodigoGrupoMultiEC());
        return ident;
    }

    private IdentTerminal determinarTerminalMultiECConfirmacao(EntradaCTFClientCtrl entradaIntegracao) {
        IdentTerminal identTerminal;
        if (entradaIntegracao == null || !entradaIntegracao.isIdentificadorMultiECCtrl() || entradaIntegracao.getIdentificadorMultiEC() == null || entradaIntegracao.getIdentificadorMultiEC().length() == 0) {
            logger.log("ERROR", "Identificador do terminal Multi-EC n\u00e3o enviado, enviar o campo 102");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5401, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENVIADO PELA AUTOMACAO"));
            return null;
        }
        ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
        try {
            identTerminal = controladorMultiEC.determinarTerminal(entradaIntegracao.getIdentificadorMultiEC());
        }
        catch (IdentificadorMultiECNaoEncontradoException e) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5402, "IDENTIFICADOR DO TERMINAL MULTI-EC NAO ENCONTRADO, EC ENVIADO PELA AUTOMACAO: " + entradaIntegracao.getIdentificadorMultiEC()));
            return null;
        }
        return identTerminal;
    }

    private boolean validaIdentTerminal(IdentTerminal ident) {
        try {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (!ident.getEstabelecimento().equals(conf.getEstabelecimento())) {
                logger.warn("Estabelecimento difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getEstabelecimento() + " / PDV -> " + ident.getEstabelecimento());
                return false;
            }
            if (!conf.validaLoja(ident.getLoja())) {
                logger.warn("Loja difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getLoja() + " / PDV -> " + ident.getLoja());
                return false;
            }
            if (!conf.validaTerminal(ident.getTerminal())) {
                logger.warn("Terminal (PDV) difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getTerminal() + " / PDV -> " + ident.getTerminal());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validaVersaoAc(String versao) {
        try {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (versao == null) {
                logger.warn("Vers\u00e3o difere da configura\u00e7\u00e3o. Vers\u00e3o n\u00e3o informada pela AC");
                return false;
            }
            if (versao.equals(conf.getVersaoAC())) {
                return true;
            }
            logger.warn("Vers\u00e3o difere da configura\u00e7\u00e3o. CTFClient -> " + conf.getVersaoAC() + " / PDV -> " + versao);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validaEntrada(EntradaCTFClientCtrl entrada, ConfCTFClient confCTFClient) throws ExcecaoEntradaCTFClient {
        int operacao = entrada.getOperacao();
        if (!entrada.isNumeroTransacaoCtrl() && operacao != 191) {
            throw new ExcecaoEntradaCTFClient(20, "5323", new String[]{"NUMERO TRANS INVALIDO"});
        }
        if (!entrada.isDataAberturaCtrl()) {
            throw new ExcecaoEntradaCTFClient(20, "5324", new String[]{"DATA AC INVALIDA"});
        }
        if (confCTFClient.isIntegracaoStandAlone() && operacao != 800 && !entrada.isVersaoAcCtrl()) {
            throw new ExcecaoEntradaCTFClient(20, "5325", new String[]{"VERSAO AC INVALIDA"});
        }
    }

    private SaidaCTFClient getSaidaCTFClient(SaidaApiTefC saidaApiTef, int operacao, Process process, IdentTerminal ident, EntradaCTFClient entrada, boolean multiplosTerminais, boolean multiTransacao) {
        Plano plano;
        ConfCTFClient config = controladorConfCTFClient.getConfig();
        SaidaCTFClient saidaCTFClient = new SaidaCTFClient();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entrada != null) {
            saidaCTFClient.setOperacao(entrada.getOperacao());
            saidaCTFClient.setDocumento(entrada.getNumeroCupom());
        }
        if (ident != null) {
            saidaCTFClient.setEstabelecimento(ident.getEstabelecimento());
            saidaCTFClient.setLoja(ident.getLoja());
            saidaCTFClient.setTerminal(ident.getTerminal());
        }
        if (saidaApiTef == null) {
            saidaCTFClient = this.getSaidaCTFClientErro(20, "5306", "OPERACAO NAO PERMITIDA", ident, entrada, multiplosTerminais, multiTransacao);
            return saidaCTFClient;
        }
        if (saidaApiTef.getRetorno() == 0) {
            List<CartaoPrepagoDigital> listCartaoPrepagoDigital;
            Object creditoDigital;
            RespostaBypass respostaBypass;
            saidaCTFClient.setCodigoAprovacao(saidaApiTef.getCodigoAprovacao());
            saidaCTFClient.setMaxParcCJuros(saidaApiTef.getQtdMaximaParcelaComJuros());
            saidaCTFClient.setMaxParcSJuros(saidaApiTef.getQtdMaximaParcelaSemJuros());
            saidaCTFClient.setMinParcCJuros(saidaApiTef.getQtdMinimaParcelaComJuros());
            saidaCTFClient.setMinParcSJuros(saidaApiTef.getQtdMinimaParcelaSemJuros());
            saidaCTFClient.setNomeCliente(saidaApiTef.getNomeCliente());
            saidaCTFClient.setNomeInstFinanceira(saidaApiTef.getNomeInstituicaoFinanceira());
            saidaCTFClient.setTaxaJuros(saidaApiTef.getTaxaJuros());
            saidaCTFClient.setValorParcela(saidaApiTef.getValorParcela());
            saidaCTFClient.setValorTotal(saidaApiTef.getValorTotal());
            saidaCTFClient.setValorTransacao(saidaApiTef.getValorTransacao());
            saidaCTFClient.setTipoCapturaPreAutorizacao(saidaApiTef.getTipoCapturaPreAutorizacao());
            saidaCTFClient.setCodigoTransacaoCanceladaCTF(saidaApiTef.getCodigoTransacao());
            saidaCTFClient.setDadosConsultaFinanciamento(saidaApiTef.getDadosConsultaFinanciamento());
            if (Contexto.getContexto().getCartao() != null) {
                if (saidaApiTef.getPanMascarado() != null && saidaApiTef.getPanMascarado().trim().length() > 0) {
                    saidaCTFClient.setNumeroCartao(saidaApiTef.getPanMascarado());
                } else if (entradaApiTefC.getPAN() != null) {
                    String numeroCartao = MascaraCartaoUtil.getNumeroMascaradoLegado4UltimosDigitos(entradaApiTefC.getPAN());
                    saidaCTFClient.setNumeroCartao(numeroCartao);
                }
            }
            if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CREDITO CELULAR")) {
                saidaCTFClient.setNumeroCartao(entradaApiTefC.getDdd() + entradaApiTefC.getTelefone());
            }
            int operacaoTransacaoGenerica = 0;
            if (operacao == 222) {
                operacaoTransacaoGenerica = Contexto.getContexto().getOperacao();
            }
            if (operacao == 139 || operacaoTransacaoGenerica == 139) {
                RespostaConsultaAvs consultaAvs = new RespostaConsultaAvs();
                consultaAvs.setCodigoResposta(saidaApiTef.getCodigoRespostaAvs());
                consultaAvs.setResultadoConsulta(saidaApiTef.getResultadoAvs());
                saidaCTFClient.setRespostaConsultaAvs(consultaAvs);
            } else if (operacao == 180 || operacao == 181 || operacao == 153 || operacao == 155 || operacao == 152 || operacao == 154) {
                RespostaCorrespondenteBancario respostaCorBan = new RespostaCorrespondenteBancario();
                respostaCorBan.setCorrespondenteBancario(Contexto.getContexto().getCorrespondenteBancario());
                BigDecimal valorTransacao = saidaApiTef.getValorTransacao() != null && !saidaApiTef.getValorTransacao().equals(new BigDecimal(0)) ? saidaApiTef.getValorTransacao() : (entradaApiTefC.getValorTransacao() != null ? entradaApiTefC.getValorTransacao() : new BigDecimal(0));
                respostaCorBan.setValor(valorTransacao);
                if (entradaApiTefC.getValorDesconto() != null) {
                    respostaCorBan.setValorDesconto(entradaApiTefC.getValorDesconto());
                }
                if (entradaApiTefC.getValorAcrescimo() != null) {
                    respostaCorBan.setValorAcrescimo(entradaApiTefC.getValorAcrescimo());
                }
                if (entradaApiTefC.getDataVencimento() != null) {
                    respostaCorBan.setDataVencimento(entradaApiTefC.getDataVencimento());
                }
                if (entradaApiTefC.getDataVencimentoCorBan() != null) {
                    respostaCorBan.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
                }
                if (process instanceof ICapturaCodigoBarrasPagamento) {
                    String codigoBarras = entradaApiTefC.getCodigoBarras();
                    int modoEntrada = entradaApiTefC.getModoEntradaCodigoBarras();
                    if ((modoEntrada == 3 || modoEntrada == 3) && config.isCapturaApenasLinhaDigitavel()) {
                        if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 1) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasTitulo(codigoBarras);
                            modoEntrada = 1;
                        } else if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 2) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasConvenio(codigoBarras);
                            modoEntrada = 1;
                        }
                    }
                    respostaCorBan.setCodigoBarras(codigoBarras);
                    respostaCorBan.setModoEntrada(modoEntrada);
                }
                respostaCorBan.setModalidadePagamento(Contexto.getContexto().getTipoPagamento());
                if (entradaApiTefC.getCmc7() != null) {
                    respostaCorBan.setCmc7(entradaApiTefC.getCmc7());
                }
                saidaCTFClient.setRespostaCorrespondenteBancario(respostaCorBan);
            } else if (operacao == 227 || operacao == 118 || operacao == 126 || operacao == 301 || operacao == 182 || operacao == 266) {
                respostaBypass = new RespostaBypass();
                respostaBypass.setValue(saidaApiTef.getDadosAdicionais());
                saidaCTFClient.setRespostaBypass(respostaBypass);
            } else if (operacao == 173 || operacaoTransacaoGenerica == 173) {
                creditoDigital = new RespostaConsultaValoresCreditoDigital();
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setCodigoOperadora(saidaApiTef.getOperadoraTelefonia());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setDDD(saidaApiTef.getDDD());
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                ArrayList<BigDecimal> valores = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> bonus = new ArrayList<BigDecimal>();
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValoresCreditoDigital(valores);
                ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValoresBonus(bonus);
                ConsultaValoresCreditoDigital consultaValores = saidaApiTef.getValoresRecarga();
                if (consultaValores != null) {
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setQtdeValores(consultaValores.getQtdeValores());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setQtdeBonus(consultaValores.getQtdeValores());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValorVariavelMinimo(consultaValores.getValorVariavelMinimo());
                    ((RespostaConsultaValoresCreditoDigital)creditoDigital).setValorVariavelMaximo(consultaValores.getValorVariavelMaximo());
                    if (consultaValores.getValores() != null) {
                        for (ValorRecargaTelefone valorRecarga : consultaValores.getValores()) {
                            valores.add(valorRecarga.getValor());
                            bonus.add(valorRecarga.getBonus());
                        }
                    }
                }
                saidaCTFClient.setRespostaConsultaValoresCreditoDigital((RespostaConsultaValoresCreditoDigital)creditoDigital);
            } else if (operacao == 174) {
                creditoDigital = new RespostaCompraCreditoDigital();
                ((RespostaCompraCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaCompraCreditoDigital)creditoDigital).setCodigoOperadora(saidaApiTef.getOperadoraTelefonia());
                ((RespostaCompraCreditoDigital)creditoDigital).setDdd(saidaApiTef.getDDD());
                ((RespostaCompraCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                saidaCTFClient.setValorTransacao(entradaApiTefC.getValorTransacao());
                saidaCTFClient.setRespostaCompraCreditoDigital((RespostaCompraCreditoDigital)creditoDigital);
            } else if (operacao == 235) {
                RespostaValeGas respostaValeGas = new RespostaValeGas();
                if (entradaApiTefC.getOperadoraValeGas() != null) {
                    respostaValeGas.setDescricaoOperadora(entradaApiTefC.getOperadoraValeGas().getNome());
                }
                if (entradaApiTefC.getProdutoValeGas() != null) {
                    respostaValeGas.setCodigoProduto(entradaApiTefC.getProdutoValeGas().getCodigo());
                    respostaValeGas.setDescricaoProduto(entradaApiTefC.getProdutoValeGas().getDescricao());
                }
                respostaValeGas.setNumeroEVale(saidaApiTef.getNumeroEVale());
                saidaCTFClient.setRespostaValeGas(respostaValeGas);
            } else if (operacao == 901) {
                RespostaOperacaoCheque respostaCheque = new RespostaOperacaoCheque();
                respostaCheque.setCmc7(entradaApiTefC.getCmc7());
                respostaCheque.setTipoDocumento(entradaApiTefC.getTipoDocumento());
                if (entradaApiTefC.getTipoDocumento() == 1) {
                    respostaCheque.setDocumento(entradaApiTefC.getCnpj());
                } else {
                    respostaCheque.setDocumento(entradaApiTefC.getCpf());
                }
                respostaCheque.setDataCheque(entradaApiTefC.getDataCheque());
                respostaCheque.setBanco(entradaApiTefC.getBanco());
                respostaCheque.setAgencia(entradaApiTefC.getAgencia());
                respostaCheque.setContaCorrente(entradaApiTefC.getContaCorrente());
                saidaCTFClient.setRespostaCheque(respostaCheque);
            } else if (operacao == 183) {
                RespostaPagamentoFaturaCartao respostaPagamentoFatura = new RespostaPagamentoFaturaCartao();
                CorrespondenteBancario corban = new CorrespondenteBancario();
                corban.setCedente("");
                corban.setDataContabil(new Date());
                int tipoPagamento = Contexto.getContexto().getTipoPagamento();
                if (tipoPagamento > 0) {
                    switch (tipoPagamento) {
                        case 1: {
                            corban.setPagamentoDinheiro(true);
                            break;
                        }
                        case 2: {
                            corban.setPagamentoCheque(true);
                            break;
                        }
                        case 3: {
                            corban.setPagamentoChequeBanco(true);
                            break;
                        }
                        case 4: {
                            corban.setPagamentoDebito(true);
                            break;
                        }
                        case 5: {
                            corban.setPagamentoCredito(true);
                            break;
                        }
                        case 6: {
                            corban.setPagamentoCartaoProprio(true);
                            break;
                        }
                    }
                }
                corban.setNumeroConvenio("");
                corban.setFiller("");
                corban.setAutenticacao("");
                respostaPagamentoFatura.setCorrespondenteBancario(corban);
                BigDecimal valorTransacao = saidaApiTef.getValorTransacao() != null && !saidaApiTef.getValorTransacao().equals(new BigDecimal(0)) ? saidaApiTef.getValorTransacao() : (entradaApiTefC.getValorTransacao() != null ? entradaApiTefC.getValorTransacao() : new BigDecimal(0));
                respostaPagamentoFatura.setValorDevido(valorTransacao);
                respostaPagamentoFatura.setValorOriginal(valorTransacao);
                respostaPagamentoFatura.setPagamentoMinimo(valorTransacao);
                respostaPagamentoFatura.setNumeroDocumento("0");
                if (entradaApiTefC.getValorDesconto() != null) {
                    respostaPagamentoFatura.setValorDesconto(entradaApiTefC.getValorDesconto());
                }
                if (entradaApiTefC.getValorAcrescimo() != null) {
                    respostaPagamentoFatura.setValorAcrescimo(entradaApiTefC.getValorAcrescimo());
                }
                if (entradaApiTefC.getDataVencimentoCorBan() != null) {
                    respostaPagamentoFatura.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
                } else if (entradaApiTefC.getDataVencimento() != null) {
                    respostaPagamentoFatura.setDataVencimento(entradaApiTefC.getDataVencimento());
                }
                String codigoBarras = entradaApiTefC.getCodigoBarras();
                if (codigoBarras != null) {
                    int modoEntrada = entradaApiTefC.getModoEntradaCodigoBarras();
                    if ((modoEntrada == 3 || modoEntrada == 3) && config.isCapturaApenasLinhaDigitavel()) {
                        if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 1) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasTitulo(codigoBarras);
                            modoEntrada = 1;
                        } else if (CodigoBarrasUtil.identificaTipoConta(codigoBarras) == 2) {
                            codigoBarras = CodigoBarrasUtil.converteCodigoBarrasConvenio(codigoBarras);
                            modoEntrada = 1;
                        }
                    }
                    respostaPagamentoFatura.setCodigoBarras(codigoBarras);
                    respostaPagamentoFatura.setModoEntrada(modoEntrada);
                }
                respostaPagamentoFatura.setModalidadePagamento(Contexto.getContexto().getTipoPagamento());
                if (entradaApiTefC.getCmc7() != null) {
                    respostaPagamentoFatura.setCmc7(entradaApiTefC.getCmc7());
                }
                saidaCTFClient.setRespostaPagamentoFaturaCartao(respostaPagamentoFatura);
            } else if (operacao == 172) {
                RespostaConsultaAnaliticaSPC respostaConsultaAnaliticaSPC = new RespostaConsultaAnaliticaSPC();
                if (saidaApiTef.getBit62() != null) {
                    respostaConsultaAnaliticaSPC.setBit62(saidaApiTef.getBit62());
                }
                saidaCTFClient.setRespostaConsultaAnaliticaSPC(respostaConsultaAnaliticaSPC);
            } else if (operacao == 260) {
                RespostaAtivacaoCartaoPrepago respostaAtivacaoCartaoPrepago = new RespostaAtivacaoCartaoPrepago();
                respostaAtivacaoCartaoPrepago.setValorCartaoPrepago(saidaApiTef.getValorCartaoPrepago());
                respostaAtivacaoCartaoPrepago.setValorBonus(saidaApiTef.getValorBonus());
                respostaAtivacaoCartaoPrepago.setValorAtivacao(saidaApiTef.getValorAcrescimo());
                respostaAtivacaoCartaoPrepago.setValorDesconto(saidaApiTef.getValorDesconto());
                respostaAtivacaoCartaoPrepago.setValorPago(saidaApiTef.getValorTransacao());
                saidaCTFClient.setRespostaAtivacaoCartaoPrepago(respostaAtivacaoCartaoPrepago);
            } else if (operacao == 277 || operacao == 278) {
                RespostaProdutosPromocionais respostaProdutosPromocionais = new RespostaProdutosPromocionais();
                respostaProdutosPromocionais.setTimestamp(saidaApiTef.getTimestampProdutosPromocionais());
                ArrayList<ProdutoPromocional> listProdutosPromocionaisResposta = new ArrayList<ProdutoPromocional>();
                List<ProdutoPromocional> listProdutosPromocionais = null;
                if (operacao == 277) {
                    listProdutosPromocionais = saidaApiTef.getProdutosPromocionais();
                } else if (operacao == 278) {
                    listProdutosPromocionais = saidaApiTef.getDadosProdutosPromocionais();
                }
                if (listProdutosPromocionais != null) {
                    for (ProdutoPromocional produtoSaidaApiTef : listProdutosPromocionais) {
                        ProdutoPromocional produtoResposta = new ProdutoPromocional();
                        produtoResposta.setCodigoEAN(produtoSaidaApiTef.getCodigoEAN());
                        if (operacao == 278) {
                            produtoResposta.setQuantidade(produtoSaidaApiTef.getQuantidade());
                            produtoResposta.setValorDesconto(produtoSaidaApiTef.getValorDesconto());
                        }
                        listProdutosPromocionaisResposta.add(produtoResposta);
                    }
                    respostaProdutosPromocionais.setListProdutosPromocionais(listProdutosPromocionaisResposta);
                    saidaCTFClient.setRespostaProdutosPromocionais(respostaProdutosPromocionais);
                }
            } else if (operacao == 407) {
                String[] valores;
                String adicionais = saidaApiTef.getDadosAdicionais();
                if (adicionais != null && (valores = StringUtil.splitPorTamanho(adicionais, 6)) != null && valores.length > 0) {
                    ArrayList<TransacaoPendente> transacoesPendentes = new ArrayList<TransacaoPendente>();
                    for (int i = 0; i < valores.length; ++i) {
                        transacoesPendentes.add(new TransacaoPendente(Integer.parseInt(valores[i])));
                    }
                    saidaCTFClient.setTransacoesPendentes(transacoesPendentes);
                }
            } else if (operacao == 270) {
                RespostaSimulacaoCrediario respostaSimulacaoCrediario = new RespostaSimulacaoCrediario();
                respostaSimulacaoCrediario.setDadosSimulacao(saidaApiTef.getDadosFinanciamentoCrediario());
                saidaCTFClient.setRespostaSimulacaoCrediario(respostaSimulacaoCrediario);
            } else if (operacao == 283) {
                creditoDigital = new RespostaConsultaTelefoneCreditoDigital();
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setVersaoLayout(config.getVersaoLayoutCD());
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setDdd(saidaApiTef.getDDD());
                ((RespostaConsultaTelefoneCreditoDigital)creditoDigital).setTelefone(saidaApiTef.getTelefone());
                saidaCTFClient.setRespostaConsultaTelefoneCreditoDigital((RespostaConsultaTelefoneCreditoDigital)creditoDigital);
            } else if (operacao == 908) {
                saidaCTFClient.setCapturaDadoPinpad(Contexto.getContexto().getCapturaDadoPinpad());
            } else if (operacao == 307 || operacao == 308 || operacao == 309 || operacao == 310 || operacao == 311 || operacao == 312 || operacao == 313 || operacao == 314 || operacao == 315 || operacao == 316 || operacao == 317 || operacao == 318 || operacao == 319 || operacao == 320 || operacao == 321 || operacao == 323 || operacao == 324 || operacao == 325) {
                RespostaTransacoesSAA respostaTransacoesSAA = new RespostaTransacoesSAA();
                respostaTransacoesSAA.setBit62(saidaApiTef.getDadosAdicionais());
                saidaCTFClient.setRespostaTransacoesSAA(respostaTransacoesSAA);
                if ((operacao == 307 || operacao == 308) && saidaApiTef != null && saidaApiTef.getNumeroCartao() != null & saidaApiTef.getNumeroCartao().length() >= 8) {
                    saidaCTFClient.setNumeroValeTroca(saidaApiTef.getNumeroCartao().substring(saidaApiTef.getNumeroCartao().length() - 8, saidaApiTef.getNumeroCartao().length()));
                }
            } else if (operacao == 329) {
                RespostaConsultaEstabelecimentosMultiEC respostaMultiEC = new RespostaConsultaEstabelecimentosMultiEC();
                ArrayList<EstabelecimentoMultiECResposta> listEstabelecimentosResposta = new ArrayList<EstabelecimentoMultiECResposta>();
                ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
                if (controladorMultiEC.getDadosEstabelecimentosMultiEC() != null && controladorMultiEC.getDadosEstabelecimentosMultiEC().getListEstabelecimentoMultiECs() != null) {
                    for (EstabelecimentoMultiEC estabelecimentoApitef : controladorMultiEC.getDadosEstabelecimentosMultiEC().getListEstabelecimentoMultiECs()) {
                        EstabelecimentoMultiECResposta estabelecimentoResposta = new EstabelecimentoMultiECResposta();
                        estabelecimentoResposta.setEstabelecimento(estabelecimentoApitef.getEstabelecimento());
                        estabelecimentoResposta.setLoja(estabelecimentoApitef.getLoja());
                        estabelecimentoResposta.setDescricao(estabelecimentoApitef.getDescricao());
                        estabelecimentoResposta.setIdentificadorEstabelecimento(estabelecimentoApitef.getIdentificadorEstabelecimento());
                        listEstabelecimentosResposta.add(estabelecimentoResposta);
                    }
                }
                respostaMultiEC.setListEstabelecimentosComerciais(listEstabelecimentosResposta);
                saidaCTFClient.setRespostaConsultaEstabelecimentosMultiEC(respostaMultiEC);
            } else if (operacao == 112) {
                if (entrada.isExecutaConsultaFinanciamentoAutorizadora() && saidaCTFClient.getDadosConsultaFinanciamento() != null) {
                    respostaBypass = new RespostaBypass();
                    respostaBypass.setValue(saidaCTFClient.getDadosConsultaFinanciamento());
                    saidaCTFClient.setRespostaBypass(respostaBypass);
                }
            } else if (operacao == 337 && (listCartaoPrepagoDigital = saidaApiTef.getListCartaoPrepagoDigital()) != null) {
                ArrayList<CartaoPrepagoDigitalResposta> listCartaoResposta = new ArrayList<CartaoPrepagoDigitalResposta>();
                for (CartaoPrepagoDigital cartaoPrepago : listCartaoPrepagoDigital) {
                    CartaoPrepagoDigitalResposta cartaoPrepagoResposta = new CartaoPrepagoDigitalResposta();
                    cartaoPrepagoResposta.setCodigoEAN(cartaoPrepago.getCodigoEAN());
                    cartaoPrepagoResposta.setDescricao(cartaoPrepago.getDescricao());
                    cartaoPrepagoResposta.setValor(cartaoPrepago.getValor());
                    listCartaoResposta.add(cartaoPrepagoResposta);
                }
                RespostaConsultaCartaoPrepagoDigital resposta = new RespostaConsultaCartaoPrepagoDigital();
                resposta.setListCartaoPrepagoDigital(listCartaoResposta);
                saidaCTFClient.setRespostaConsultaCartaoPrepagoDigital(resposta);
            }
        } else if (saidaApiTef != null && saidaApiTef.getRetorno() == 20) {
            if (logger.isDebugEnabled()) {
                logger.debug("Verificar CTFClient, altera\u00e7\u00e3o na leitura do chip");
            }
            return this.getSaidaCTFClientErro(ident, entrada, multiplosTerminais, multiTransacao);
        }
        if (Contexto.getContexto().getCartao() != null) {
            Cartao cartao = Contexto.getContexto().getCartao();
            if (cartao == Cartao.DIGITADO) {
                saidaCTFClient.setTipoCapturaCartao(1);
            } else if (cartao == Cartao.MAGNETICO) {
                saidaCTFClient.setTipoCapturaCartao(2);
            } else if (cartao == Cartao.CHIP) {
                saidaCTFClient.setTipoCapturaCartao(5);
            } else if (cartao == Cartao.CONTACTLESS_EMV) {
                saidaCTFClient.setTipoCapturaCartao(7);
            } else if (cartao == Cartao.CONTACTLESS_TARJA) {
                saidaCTFClient.setTipoCapturaCartao(6);
            }
        }
        if (Contexto.getContexto().getPinInfo() != null) {
            if (Contexto.getContexto().getPinInfo().isCapturadoVerificacaoOnline() || Contexto.getContexto().getPinInfo().isVerificadoOffline()) {
                saidaCTFClient.setVerificacaoPortadorCartao(1);
            } else if (!(Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_TARJA && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV || Contexto.getContexto().getPinInfo().isCapturadoVerificacaoOnline() || Contexto.getContexto().getPinInfo().isVerificadoOffline() || Contexto.getContexto().getPinInfo().isRequerAssinatura())) {
                saidaCTFClient.setVerificacaoPortadorCartao(3);
            } else {
                saidaCTFClient.setVerificacaoPortadorCartao(2);
            }
        } else if (saidaApiTef.getRetorno() == 0) {
            saidaCTFClient.setVerificacaoPortadorCartao(2);
        }
        if (saidaApiTef.getRetorno() != 20) {
            saidaCTFClient.setMensagemCTF(saidaApiTef.getDisplayCTF());
            saidaCTFClient.setCodigoRetorno(saidaApiTef.getRetorno());
            saidaCTFClient.setCodigoErro(saidaApiTef.getCodigoErro());
        }
        saidaCTFClient.setNsuCTF(saidaApiTef.getNsuCTF());
        saidaCTFClient.setCodigoRespAutorizadora(saidaApiTef.getCodigoRespostaAutorizadora());
        if (saidaApiTef.getNsuAutorizacao() != null) {
            try {
                saidaCTFClient.setNsuAutorizadora(new Long(saidaApiTef.getNsuAutorizacao()));
            }
            catch (Exception cartao) {
                // empty catch block
            }
        }
        saidaCTFClient.setDadosComplementaresTef(saidaApiTef.getDadosComplementaresTef());
        if (saidaApiTef != null) {
            VerifyContentUtil.preencheDadosSaida(saidaApiTef);
        }
        if (saidaApiTef.getDataAutorizadora() != null) {
            saidaCTFClient.setHorarioTransacao(saidaApiTef.getDataAutorizadora());
        } else if (Contexto.getContexto().getDataAutorizadora() != null) {
            saidaCTFClient.setHorarioTransacao(Contexto.getContexto().getDataAutorizadora());
        } else {
            saidaCTFClient.setHorarioTransacao(new Date());
        }
        if (Contexto.getContexto().getCodigoVan() > 0) {
            saidaCTFClient.setCodigoVan(Contexto.getContexto().getCodigoVan());
        }
        if (Contexto.getContexto().getNomeVan() != null) {
            saidaCTFClient.setNomeVan(Contexto.getContexto().getNomeVan());
        }
        if (Contexto.getContexto().getCodigoVanAlfa() != null) {
            saidaCTFClient.setCodigoVanAlfa(Contexto.getContexto().getCodigoVanAlfa());
        }
        if (Contexto.getContexto().getCodigoAutorizadora() != null) {
            saidaCTFClient.setCodigoAutorizadora(Contexto.getContexto().getCodigoAutorizadora());
            saidaCTFClient.setNomeAutorizadora(Contexto.getContexto().getNomeAutorizadora());
        }
        if (Contexto.getContexto().getCodigoInstituicaoFinanceira() > 0) {
            saidaCTFClient.setCodigoInstFinanceira(Contexto.getContexto().getCodigoInstituicaoFinanceira());
            saidaCTFClient.setNomeInstFinanceira(Contexto.getContexto().getNomeInstituicaoFinanceira());
        }
        if (saidaApiTef.getNomeBandeiraProduto() != null) {
            saidaCTFClient.setNomeBandeiraProduto(saidaApiTef.getNomeBandeiraProduto());
        }
        if (saidaApiTef.getNomeRedeAdquirente() != null) {
            saidaCTFClient.setNomeRedeAdquirente(saidaApiTef.getNomeRedeAdquirente());
        }
        if (entradaApiTefC.getOperacao() != null) {
            saidaCTFClient.setCodigoTransacaoCTF(entradaApiTefC.getOperacao());
        }
        saidaCTFClient.setInformacaoCriptografada("");
        if (saidaApiTef != null) {
            saidaCTFClient.setSaldoCliente(saidaApiTef.getSaldoCliente());
            saidaCTFClient.setLogomarca(saidaApiTef.getLogomarca());
        }
        if (entradaApiTefC.getNsuCtf() > 0) {
            saidaCTFClient.setNsuCTFOriginal(entradaApiTefC.getNsuCtf());
        }
        if ((plano = Contexto.getContexto().getPlano()) != null && Plano.isPlanoParcelado(plano)) {
            saidaCTFClient.setNumeroParcelas(entradaApiTefC.getNumeroParcelas());
        }
        if (plano != null) {
            if (entradaApiTefC.getValorEntrada() != null) {
                saidaCTFClient.setValorEntrada(entradaApiTefC.getValorEntrada());
            }
            if (entradaApiTefC.getDataVencimentoDebito() != null) {
                saidaCTFClient.setData1aParcela(entradaApiTefC.getDataVencimentoDebito());
            } else if (entradaApiTefC.getDataVencimento() != null) {
                saidaCTFClient.setData1aParcela(entradaApiTefC.getDataVencimento());
            }
            if (entradaApiTefC.getValorParcela() != null) {
                saidaCTFClient.setValorParcela(entradaApiTefC.getValorParcela());
            }
            if (plano == Plano.PREDATADO && entradaApiTefC.getTipoGarantia() != -1) {
                saidaCTFClient.setTipoGarantia(entradaApiTefC.getTipoGarantia());
            }
            if (plano == Plano.AVISTA) {
                saidaCTFClient.setValorSaque(entradaApiTefC.getValorCashBack());
            }
        }
        if (Contexto.getContexto().getEntradaApiTefC().getDataTransacao() != null) {
            // empty if block
        }
        if (Contexto.getContexto().getParcelas() != null) {
            saidaCTFClient.setConsultaParcelas(Contexto.getContexto().getParcelas());
        }
        if (Contexto.getContexto().getValorDescontoMonetario() != null) {
            saidaCTFClient.setValorDesconto(Contexto.getContexto().getValorDescontoMonetario());
        }
        if (multiplosTerminais && multiTransacao) {
            saidaCTFClient.setCodigoMultitransacao(IdentTerminal.parseCodigoMultitransacao(ident));
        }
        if (saidaCTFClient.getValorTransacao() == null && entradaApiTefC.getValorTransacao() != null) {
            saidaCTFClient.setValorTransacao(entradaApiTefC.getValorTransacao());
        }
        if (!StringUtil.isEmpty(saidaApiTef.getNomeCliente())) {
            saidaCTFClient.setNomeCliente(saidaApiTef.getNomeCliente());
        } else {
            saidaCTFClient.setNomeCliente(Contexto.getContexto().getNomeCliente());
        }
        if (saidaApiTef.getDataVencimento() != null) {
            saidaCTFClient.setDataVencimentoCartao(DateUtil.parse(saidaApiTef.getDataVencimento(), "MMyy"));
        } else if (Contexto.getContexto().getDataVencimento() != null) {
            saidaCTFClient.setDataVencimentoCartao(DateUtil.parse(Contexto.getContexto().getDataVencimento(), "MMyy"));
        } else if (saidaApiTef.getVencimentoCartao() != null && saidaApiTef.getVencimentoCartao().trim().length() == 4) {
            String data = saidaApiTef.getVencimentoCartao();
            saidaCTFClient.setDataVencimentoCartao(data.substring(2) + data.substring(0, 2));
        }
        this.validaSaidaCTFClient(saidaCTFClient);
        logger.info("terminal " + ident + " retorno=" + saidaCTFClient.getCodigoRetorno() + " erro=" + saidaCTFClient.getCodigoErro() + " nsu_ctf=" + saidaCTFClient.getNsuCTF() + " resp_autorizadora=" + saidaCTFClient.getCodigoRespAutorizadora());
        return saidaCTFClient;
    }

    private void trataByPass(EntradaCTFClientCtrl entradaIntegracaoCtrl) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracaoCtrl.isValorTransacaoCtrl()) {
            entradaApiTefC.setValorTransacao(entradaApiTefC.getValorTransacao());
        } else {
            entradaApiTefC.setValorTransacao(null);
        }
        if (entradaApiTefC.getInfo() == null && entradaIntegracaoCtrl.isInfoCtrl()) {
            entradaApiTefC.setInfo(entradaIntegracaoCtrl.getInfo());
        }
        if (entradaApiTefC.getValorDesconto() == null && entradaIntegracaoCtrl.isValorDescontoCtrl()) {
            entradaApiTefC.setValorDesconto(entradaIntegracaoCtrl.getValorDesconto());
        }
        if (entradaApiTefC.getValorAcrescimo() == null && entradaIntegracaoCtrl.isValorAcrescimoCtrl()) {
            entradaApiTefC.setValorAcrescimo(entradaIntegracaoCtrl.getValorAcrescimo());
        }
        if (Contexto.getContexto().getCartao() == null && entradaIntegracaoCtrl.isModoEntradaCartaoCtrl()) {
            entradaApiTefC.setModoEntrada(entradaIntegracaoCtrl.getModoEntradaCartao());
        }
        if (Contexto.getContexto().getPlano() == null && entradaIntegracaoCtrl.isNumeroParcelasCtrl()) {
            int numeroParcelas = entradaIntegracaoCtrl.getNumeroParcelas();
            if (numeroParcelas > 1) {
                if (entradaIntegracaoCtrl.isValorEntradaCtrl()) {
                    Contexto.getContexto().setPlano(Plano.CDC);
                    entradaApiTefC.setValorEntrada(entradaIntegracaoCtrl.getValorEntrada());
                    entradaApiTefC.setNumeroParcelas(numeroParcelas);
                } else {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    entradaApiTefC.setNumeroParcelas(numeroParcelas);
                }
            } else if (numeroParcelas == 1) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                if (entradaIntegracaoCtrl.isValorSaqueCtrl()) {
                    entradaApiTefC.setValorCashBack(entradaIntegracaoCtrl.getValorSaque());
                }
                entradaApiTefC.setNumeroParcelas(1);
            } else {
                entradaApiTefC.setNumeroParcelas(0);
            }
        }
        if (entradaApiTefC.getNsuCtf() == 0 && entradaIntegracaoCtrl.isNsuCTFCtrl()) {
            entradaApiTefC.setNsuCtf(entradaIntegracaoCtrl.getNsuCTF());
        }
        if (entradaApiTefC.getValorTaxaEmbarque() == null && entradaIntegracaoCtrl.isValorTaxaEmbarqueCtrl()) {
            entradaApiTefC.setValorTaxaEmbarque(entradaIntegracaoCtrl.getValorTaxaEmbarque());
        }
        if (entradaApiTefC.getValorTaxaServico() == null && entradaIntegracaoCtrl.isValorTaxaServicoCtrl()) {
            entradaApiTefC.setValorTaxaServico(entradaIntegracaoCtrl.getValorTaxaServico());
        }
    }

    private Process getProcess(EntradaCTFClientCtrl entradaIntegracao) {
        int key = entradaIntegracao.getOperacao();
        if (key == 6) {
            return new ProcessConfirmacao(entradaIntegracao);
        }
        if (key == 7) {
            int numeroTransacao = 1;
            if (controladorConfCTFClient.getConfig().isIntegracaoTefIP() || controladorConfCTFClient.getConfig().isIntegracaoTefDisc()) {
                numeroTransacao = entradaIntegracao.getNumeroTransacao();
            } else if (entradaIntegracao != null) {
                entradaIntegracao.setNumeroTransacao(numeroTransacao);
            }
            return new ProcessDesfazimento(entradaIntegracao, numeroTransacao);
        }
        if (key == 191) {
            int numeroTransacao = 1;
            if (entradaIntegracao != null) {
                entradaIntegracao.setNumeroTransacao(numeroTransacao);
            }
            return new ProcessDesfazimentoGeral(entradaIntegracao, numeroTransacao);
        }
        if (key == 101 || key == 103 || key == 105 || key == 104 || key == 108 || key == 109 || key == 406) {
            if (entradaIntegracao.isAutenticacaoEmissor()) {
                return new ProcessEcommerceAutenticado(entradaIntegracao);
            }
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "DEBITO GENERICO");
        }
        if (key == 224) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), "DEBITO GENERICO", 0);
        }
        if (key == 106) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "VOUCHER GENERICO");
        }
        if (key == 107) {
            return new ProcessVoucher(entradaIntegracao);
        }
        if (key == 405 || key == 111 || key == 110) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "OPERACAO CONSULTA CDC COM PARCELA A VISTA");
        }
        if (key == 112 || key == 114 || key == 113) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "CREDITO GENERICO");
        }
        if (key == 120 || key == 122 || key == 121) {
            if (entradaIntegracao.isAutenticacaoEmissor()) {
                return new ProcessEcommerceAutenticado(entradaIntegracao);
            }
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessCreditoMultiTerminal(entradaIntegracao);
            }
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "CREDITO GENERICO");
        }
        if (key == 223) {
            Contexto.getContexto().getEntradaApiTefC().setValorTransacao(entradaIntegracao.getValorTransacao());
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), "CREDITO GENERICO", entradaIntegracao.getCodigoOrigemTransacao());
        }
        if (key == 142 || key == 143) {
            return new ProcessCreditoPrivateLabel(entradaIntegracao, "OPERACAO CREDITO PRIVATE LABEL");
        }
        if (key == 140) {
            return new ProcessCashPrivateLabel(entradaIntegracao, 1);
        }
        if (key == 401 || key == 115 || key == 117 || key == 116 || key == 123 || key == 125 || key == 124) {
            return new ProcessCreditoIATA(entradaIntegracao);
        }
        if (key == 402 || key == 146 || key == 149 || key == 150 || key == 147) {
            return new ProcessAutorizacaoIATA(entradaIntegracao);
        }
        if (key == 404 || key == 132 || key == 168 || key == 167 || key == 133 || key == 170 || key == 169) {
            if (entradaIntegracao.isMultiTerminal()) {
                if (entradaIntegracao.getTipoCapturaPreAutorizacao() == 1) {
                    return new ProcessCreditoMultiTerminal(entradaIntegracao);
                }
                return new ProcessConfirmacaoPreAutorizacaoWEB(entradaIntegracao);
            }
            return new ProcessConfirmacaoPreAutorizacao(entradaIntegracao);
        }
        if (key == 158 || key == 159 || key == 128 || key == 134 || key == 411) {
            if (key == 411) {
                entradaIntegracao.setOperacao(key);
            } else {
                entradaIntegracao.setOperacao(128);
            }
            String tipoOperacao = key == 134 ? "OPERACAO CANCELAMENTO PRE-AUTORIZACAO" : "OPERACAO CANCELAMENTO";
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessCancelamentoMultiTerminal(entradaIntegracao);
            }
            return new ProcessCancelamento(entradaIntegracao, tipoOperacao);
        }
        if (key == 156) {
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessCancelamentoMultiTerminal(entradaIntegracao);
            }
            return new ProcessCancelamento(entradaIntegracao);
        }
        if (key == 139) {
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessConsultaAvsMultiTerminal(entradaIntegracao);
            }
            return new ProcessConsultaAvs(entradaIntegracao);
        }
        if (key == 141) {
            return new ProcessCashPrivateLabel(entradaIntegracao, 2);
        }
        if (key == 144 || key == 145) {
            return new ProcessCreditoPrivateLabel(entradaIntegracao, "OPERACAO CONSULTA CREDITO PRIVATE LABEL");
        }
        if (key == 229) {
            return new ProcessReimpressaoComprovante(entradaIntegracao);
        }
        if (key == 180 || key == 181 || key == 153 || key == 155 || key == 154 || key == 152) {
            String tipoOperacao = "";
            switch (key) {
                case 180: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO";
                    break;
                }
                case 181: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO";
                    break;
                }
                case 153: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO";
                    break;
                }
                case 155: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO";
                    break;
                }
                case 152: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO";
                    break;
                }
                case 154: {
                    tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO";
                }
            }
            return new ProcessCorrespondenteBancario(entradaIntegracao, tipoOperacao);
        }
        if (key == 129) {
            return new ProcessConsultaCheque(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), "OPERACAO CONSULTA CHEQUE");
        }
        if (key == 137) {
            return new ProcessConsultaCheque(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), "OPERACAO GARANTIA CHEQUE");
        }
        if (key == 231 || key == 230) {
            return new ProcessPagamentoContas(entradaIntegracao, false);
        }
        if (key == 182 || key == 348 || key == 183) {
            String operacao = "";
            switch (key) {
                case 182: {
                    operacao = "OPERACAO CONSULTA FATURA CARTAO";
                    break;
                }
                case 348: {
                    operacao = "OPERACAO_CONSULTA_FATURA_CARTAO_DETALHADA";
                    break;
                }
                case 183: {
                    operacao = "OPERACAO PAGAMENTO FATURA CARTAO";
                }
            }
            return new ProcessPagamentoFaturaCartao(entradaIntegracao, null, operacao);
        }
        if (key == 222) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), "OUTRAS TRANSACOES", 0);
        }
        if (key == 403 || key == 119 || key == 127) {
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessPreAutorizacaoWEB(entradaIntegracao);
            }
            return new ProcessPreAutorizacao(entradaIntegracao);
        }
        if (key == 400) {
            return new ProcessCargaTabelaForcadaTest();
        }
        if (key == 173 || key == 174) {
            String operacao = key == 173 ? "CONSULTA DE CREDITO DIGITAL" : "COMPRA DE CREDITO DIGITAL";
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessCreditoDigitalMultiTerminal(entradaIntegracao, operacao);
            }
            return new ProcessCreditoDigital(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operacao);
        }
        if (key == 225) {
            return new ProcessInicioDia(entradaIntegracao);
        }
        if (key == 226) {
            return new ProcessConsultaCartao(entradaIntegracao, entradaIntegracao.getNumeroTransacao());
        }
        if (key == 227 || key == 303 || key == 304 || key == 305) {
            return new ProcessBypass(entradaIntegracao, entradaIntegracao.getNumeroTransacao());
        }
        if (key == 232 || key == 233 || key == 234) {
            return new ProcessCreditoCelular(entradaIntegracao, entradaIntegracao.getNumeroTransacao());
        }
        if (key == 235) {
            return new ProcessValeGas(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
        }
        if (key == 236) {
            return new ProcessTroco(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), "OPERACAO TROCO SURPRESA");
        }
        if (key == 254) {
            return new ProcessResgatePremio(entradaIntegracao, entradaIntegracao.getNumeroTransacao());
        }
        if (key == 225) {
            return new ProcessInicioDia(entradaIntegracao);
        }
        if (key == 239) {
            return new ProcessEstatisticaManual(entradaIntegracao);
        }
        if (key == 220) {
            return new ProcessBaixaTecnicaManual(entradaIntegracao.getNumeroTransacao());
        }
        if (key == 118 || key == 126) {
            if (key == 126) {
                logger.info("transa\u00e7\u00e3o " + key + " redirecionada para " + 118);
            }
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessConsultaFinanciamentoCreditoWeb(entradaIntegracao);
            }
            return new ProcessConsultaFinanciamentoCredito(entradaIntegracao);
        }
        if (key == 245) {
            return new ProcessSaqueCartao(entradaIntegracao, "OPE_SAQUE_CARTAO_CREDITO");
        }
        if (key == 246) {
            return new ProcessSaqueCartao(entradaIntegracao, "OPE_SAQUE_CARTAO_DEBITO");
        }
        if (key == 900) {
            return new ProcessTefIPFuncoesADM(entradaIntegracao);
        }
        if (key == 902) {
            return new ProcessTefIPVendaCartao(entradaIntegracao);
        }
        if (key == 901) {
            return new ProcessTefIPOperacoesCheque(entradaIntegracao);
        }
        if (key == 903) {
            return new ProcessTefIpEnvioFacil(entradaIntegracao);
        }
        if (key == 255 || key == 334) {
            if (key == 255) {
                Contexto.getContexto().setTipoOperacao("OPERACAO FUEL CONTROL");
            } else if (key == 334) {
                Contexto.getContexto().setTipoOperacao("OPERACAO RESERVA FUEL CONTROL");
            }
            return new ProcessFuelControl(entradaIntegracao);
        }
        if (key == 12) {
            return new ProcessUltimoComprovante();
        }
        if (key == 800) {
            return new ProcessConfigurarTerminal();
        }
        if (key == 256 || key == 257 || key == 258) {
            String tipoOperacao = key == 256 ? "OPERACAO CONSULTA DROGAO COM CARTAO" : (key == 257 ? "OPERACAO CONSULTA DROGAO COM CPF" : "OPERACAO PAGAMENTO DROGAO");
            return new ProcessOperacoesDrogao(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), tipoOperacao);
        }
        if (key == 250) {
            return new ProcessConsultaSaldo(entradaIntegracao, "OPE_CONSULTA_SALDO_DEBITO");
        }
        if (key == 251) {
            return new ProcessConsultaSaldo(entradaIntegracao, "OPE_CONSULTA_SALDO_CREDITO");
        }
        if (key == 247) {
            return new ProcessSaqueTransferencia(entradaIntegracao, "OPE_SAQUE_TRANSFERENCIA_CREDITO");
        }
        if (key == 248) {
            return new ProcessSaqueCartao(entradaIntegracao, "OPE_SIMULACAO_SAQUE_CREDITO");
        }
        if (key == 249) {
            return new ProcessSaqueTransferencia(entradaIntegracao, "OPE_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO");
        }
        if (key == 252) {
            return new ProcessResgateFidelidade(entradaIntegracao);
        }
        if (key == 253) {
            return new ProcessRecargaCartaoPrePago(entradaIntegracao);
        }
        if (key == 172) {
            if (entradaIntegracao.isMultiTerminal()) {
                return new ProcessConsultaAnaliticaSpcWeb(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
            }
            return new ProcessConsultaAnaliticaSpc(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
        }
        if (key == 259) {
            return new ProcessCriptografiaDUKPT("OPE_INJECAO_MANUAL_CHAVE_DUKPT", entradaIntegracao, 0, 0);
        }
        if (key == 263 || key == 262 || key == 300) {
            String operacao = null;
            if (key == 263) {
                operacao = "OPE_CONSULTA_CARTAO_PRESENTE";
            } else if (key == 262) {
                operacao = "OPE_RECARGA_CARTAO_PRESENTE";
            } else if (key == 300) {
                operacao = "OPE_ATIVACAO_CARTAO_PRESENTE";
            }
            return new ProcessCartaoPresente(operacao, entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
        }
        if (key == 264) {
            return new ProcessDepositoConta(entradaIntegracao);
        }
        if (key == 340) {
            return new ProcessDepositoCartao(entradaIntegracao);
        }
        if (key == 267 || key == 269) {
            String tipoOperacaoCrediario = null;
            if (key == 267) {
                tipoOperacaoCrediario = "OPE_DEBITO_CREDIARIO";
            } else if (key == 269) {
                tipoOperacaoCrediario = "OPE_CREDITO_CREDIARIO";
            }
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, tipoOperacaoCrediario);
        }
        if (key == 270) {
            return new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "OPE_SIMULACAO_CREDIARIO_CREDITO");
        }
        if (key == 277) {
            return new ProcessCargaProdutosPromocionais(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom());
        }
        if (key == 278) {
            return new ProcessDescontoProdutosPromocionais(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getNumeroCupom(), entradaIntegracao.getIdentTerminal());
        }
        if (key == 407) {
            return new ProcessConsultaPendencia(entradaIntegracao);
        }
        if (key == 271) {
            return new ProcessTrocaSenha(entradaIntegracao, entradaIntegracao.getNumeroTransacao());
        }
        if (key == 279) {
            return new ProcessConfirmacaoPreVenda(entradaIntegracao);
        }
        if (key == 280 || key == 281) {
            String operacao = null;
            if (key == 280) {
                operacao = "OPE_CONFIRMACAO_NSU_CTF";
            } else if (key == 281) {
                operacao = "OPE_DESFAZIMENTO_NSU_CTF";
            }
            return new ProcessConfirmacaoDesfazimentoNSUCTF(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), operacao);
        }
        if (key == 282 || key == 284) {
            String tipoOperacao = "";
            if (key == 282) {
                tipoOperacao = "OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO";
            } else if (key == 284) {
                tipoOperacao = "OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO";
            }
            return new ProcessConvenioCombustivel(entradaIntegracao, tipoOperacao);
        }
        if (key == 283) {
            return new ProcessConsultaTelefoneCreditoDigital(entradaIntegracao);
        }
        if (key == 286) {
            return new ProcessCapturaCredito(entradaIntegracao);
        }
        if (key == 289 || key == 290 || key == 291 || key == 292) {
            String tipoOperacao = "";
            if (key == 289) {
                tipoOperacao = "OPE_DOTZ_ACUMULO";
            } else if (key == 290) {
                tipoOperacao = "OPE_DOTZ_RESGATE";
            } else if (key == 291) {
                tipoOperacao = "OPE_DOTZ_CONSULTA_SALDO";
            } else if (key == 292) {
                tipoOperacao = "OPE_DOTZ_CONSULTA_EXTRATO";
            }
            return new ProcessDotz(entradaIntegracao, tipoOperacao);
        }
        if (key == 301 || key == 302) {
            return new ProcessIdentificacaoAssociado();
        }
        if (key == 260 || key == 272 || key == 274 || key == 275 || key == 276) {
            return new ProcessCartaoPrepago(false, entradaIntegracao);
        }
        if (key == 273) {
            return new ProcessCartaoPrepago(true, entradaIntegracao);
        }
        if (key == 285) {
            return new ProcessAtualizacaoChip();
        }
        if (key == 287 || key == 288) {
            String tipoOperacao = "";
            if (key == 287) {
                tipoOperacao = "OPERACAO AUTO";
            } else if (key == 288) {
                tipoOperacao = "OPERACAO AUTO CONSULTA SALDO";
            }
            return new ProcessAuto(tipoOperacao);
        }
        if (key == 908) {
            return new ProcessCapturaDadosPinpad(entradaIntegracao);
        }
        if (key == 307 || key == 308 || key == 309 || key == 310 || key == 311 || key == 312 || key == 313 || key == 314 || key == 315 || key == 316 || key == 317 || key == 318 || key == 319 || key == 320 || key == 321 || key == 323 || key == 324 || key == 325) {
            String tipoOperacao = "";
            if (key == 307) {
                tipoOperacao = "OPE_EMISSAO_VALE_TROCA";
            } else if (key == 308) {
                tipoOperacao = "OPE_RESGATE_VALE_TROCA";
            } else if (key == 309) {
                tipoOperacao = "OPE_CONSULTA_REIMPRESSAO_VALE_TROCA";
            } else if (key == 310) {
                tipoOperacao = "OPE_REIMPRESSAO_VALE_TROCA";
            } else if (key == 311) {
                tipoOperacao = "OPE_CONSULTA_GARANTIA_ESTENDIDA";
            } else if (key == 312) {
                tipoOperacao = "OPE_CONSULTA_GARANTIA_ROUBO_FURTO";
            } else if (key == 313) {
                tipoOperacao = "OPE_PAGAMENTO_GARANTIA_EXTENDIDA";
            } else if (key == 314) {
                tipoOperacao = "OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO";
            } else if (key == 315) {
                tipoOperacao = "OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA";
            } else if (key == 316) {
                tipoOperacao = "OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA";
            } else if (key == 317) {
                tipoOperacao = "OPE_CONSULTA_ASSOCIADO";
            } else if (key == 318) {
                tipoOperacao = "OPE_COMPRA_ASSOCIADO";
            } else if (key == 319) {
                tipoOperacao = "OPE_CARGA_HABILITACAO_CARTAO_PRESENTE";
            } else if (key == 320) {
                tipoOperacao = "OPE_RESGATE_CARTAO_PRESENTE_SAA";
            } else if (key == 321) {
                tipoOperacao = "OPE_CONSULTA_CARTAO_PRESENTE_SAA";
            } else if (key == 323) {
                tipoOperacao = "OPE_CARGA_HABILITACAO_CUPONAGEM";
            } else if (key == 324) {
                tipoOperacao = "OPE_CONSULTA_CUPONAGEM";
            } else if (key == 325) {
                tipoOperacao = "OPE_RESGATE_CUPONAGEM";
            }
            return new ProcessTransacoesSAA(tipoOperacao);
        }
        if (key == 329) {
            return new ProcessConsultaEstabelecimentosMultiEC(entradaIntegracao);
        }
        if (key == 330 || key == 331) {
            if (key == 330) {
                Contexto.getContexto().setTipoOperacao("OPE_RESGATE_FACIL");
            } else if (key == 331) {
                Contexto.getContexto().setTipoOperacao("OPE_RESGATE_FACIL_EXTRATO");
            }
            return new ProcessResgateFacil(entradaIntegracao.getNumeroTransacao());
        }
        if (key == 221) {
            return new ProcessECO();
        }
        if (key == 410) {
            return new ProcessAtivacaoSolucaoCerta();
        }
        if (key == 332 || key == 333) {
            String tipoOperacao = "";
            if (key == 332) {
                tipoOperacao = "OPE_CONSULTA_FIDELIDADE_EM_MILHAS";
            } else if (key == 333) {
                tipoOperacao = "OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS";
            }
            return new ProcessFidelidadeMilhas(entradaIntegracao, tipoOperacao);
        }
        if (key == 412) {
            return new ProcessAlteracaoPreAutorizacao(entradaIntegracao);
        }
        if (key == 335 || key == 336) {
            String tipoOperacao = null;
            tipoOperacao = key == 335 ? "OPERACAO CREDITO 4ALL" : "OPERACAO DEBITO 4ALL";
            return new ProcessCreditoDebito4All(entradaIntegracao, tipoOperacao);
        }
        if (key == 413) {
            return new ProcessDesbloqueioCartao(entradaIntegracao);
        }
        if (key == 337 || key == 338) {
            String tipoOperacao = key == 337 ? "OPERACAO CONSULTA PREPAGO DIGITAL" : "OPERACAO PREPAGO DIGITAL";
            return new ProcessCartaoPrepagoDigital(entradaIntegracao, tipoOperacao);
        }
        if (key == 266) {
            return new ProcessConsultaContaCartao(entradaIntegracao);
        }
        if (key == 349) {
            return new ProcessConsultaContaCartao(entradaIntegracao);
        }
        if (key == 342 || key == 341) {
            return new ProcessEmprestimo(entradaIntegracao);
        }
        if (key == 343) {
            return new ProcessCredito(entradaIntegracao, "OPE_CONTA_DIGITAL_PAGTO_FATURA");
        }
        if (key == 345) {
            return new ProcessCredito(entradaIntegracao, "OPE_CONTA_DIGITAL_PAGTO_TITULO");
        }
        if (key == 344) {
            return new ProcessCredito(entradaIntegracao, "OPE_CONTA_DIGITAL_PAGTO_CONCESSIONARIA");
        }
        if (key == 414) {
            return new ProcessAdesaoSeguro(entradaIntegracao);
        }
        logger.log("INFO", "Processo n\u00e3o encontrado...");
        return null;
    }

    private Process executeProcess(Process process) {
        process.setApitef(ControladorApitefC.newInstancia());
        process.setPerifericos(controladorPerifericos);
        ProcessManager.getInstance().process(process);
        return process;
    }

    private boolean validaGrupoTransacao(int operacaoOLD, int operacao) {
        if (operacaoOLD == 101) {
            if (operacao == 101 || operacao == 103 || operacao == 105 || operacao == 104 || operacao == 108 || operacao == 109) {
                return true;
            }
        } else if (operacaoOLD == 112 || operacaoOLD == 120) {
            if (operacao == 112 || operacao == 114 || operacao == 113 || operacao == 120 || operacao == 122 || operacao == 121 || operacao == 232 || operacao == 234 || operacao == 233) {
                return true;
            }
        } else if (operacaoOLD == 115) {
            if (operacao == 115 || operacao == 117 || operacao == 116 || operacao == 123 || operacao == 125 || operacao == 124) {
                return true;
            }
        } else if (operacaoOLD == 142) {
            if (operacao == 142 || operacao == 143) {
                return true;
            }
        } else if (operacaoOLD == 106) {
            if (operacao == 106) {
                return true;
            }
        } else if (operacaoOLD == 405) {
            if (operacao == 405 || operacao == 111 || operacao == 110) {
                return true;
            }
        } else {
            if (operacaoOLD == 226) {
                return true;
            }
            if (operacaoOLD == 232 || operacaoOLD == 234 || operacaoOLD == 233 ? operacao == 112 || operacao == 114 || operacao == 113 : (operacaoOLD == 256 ? operacao == 256 : (operacaoOLD == 257 ? operacao == 257 : operacaoOLD == 260 && operacao == 260))) {
                return true;
            }
        }
        return false;
    }

    private long getIdentConsulta(ContextoCTFClient contexto) {
        if (contexto.getEntradaIntegracao() != null && contexto.getEntradaIntegracao().getOperacao() == 226) {
            if (contexto.getSaidaApiTefC() != null && contexto.getSaidaApiTefC().getDataAutorizadora() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(contexto.getSaidaApiTefC().getDataAutorizadora());
                return calendar.getTimeInMillis();
            }
            logger.warn("Consulta n\u00e3o efetuada ou data n\u00e3o recuperada, a captura do timestamp n\u00e3o p\u00f4de ser realizada");
            return 0L;
        }
        return contexto.hashCode();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("op\u00e7\u00f5es deste programa:");
            System.out.println("  -versao\t  vers\u00e3o do CTFClient");
            System.out.println("  -fabricante   fabricante da solu\u00e7\u00e3o CTFClient");
        } else if (args[0].equalsIgnoreCase("-versao")) {
            System.out.println("vers\u00e3o: C0212");
        } else if (args[0].equalsIgnoreCase("-fabricante")) {
            System.out.println("fabricante: AUTTAR PROCESSAMENTO DE DADOS");
        }
        System.exit(0);
    }

    private SaidaCTFClient getSaidaCTFClientErro(IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        return this.getSaidaCTFClientErro(20, "5331", "TENTE NOVAMENTE", ident, entradaCTFClient, multiplosTerminais, multiTransacao);
    }

    private SaidaCTFClient getSaidaCTFClientErro(int retorno, String erro, String mensagem, IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        return this.getSaidaCTFClientErro(retorno, erro, new String[]{mensagem}, ident, entradaCTFClient, multiplosTerminais, multiTransacao);
    }

    private SaidaCTFClient getSaidaCTFClientErro(int retorno, String erro, String[] mensagem, IdentTerminal ident, EntradaCTFClient entradaCTFClient, boolean multiplosTerminais, boolean multiTransacao) {
        EntradaApiTefC entradaApiTefC;
        SaidaCTFClient saida = new SaidaCTFClient(retorno, erro, mensagem);
        logger.info("transa\u00e7\u00e3o recusada: " + ident + " retorno=" + retorno + " erro=" + erro);
        if (entradaCTFClient != null) {
            saida.setOperacao(entradaCTFClient.getOperacao());
            saida.setDocumento(entradaCTFClient.getNumeroCupom());
        }
        if (ident != null) {
            saida.setEstabelecimento(ident.getEstabelecimento());
            saida.setLoja(ident.getLoja());
            saida.setTerminal(ident.getTerminal());
        }
        if (multiplosTerminais && multiTransacao) {
            saida.setCodigoMultitransacao(IdentTerminal.parseCodigoMultitransacao(ident));
        }
        if ((entradaApiTefC = Contexto.getContexto().getEntradaApiTefC()) != null && entradaApiTefC.getValorTransacao() != null) {
            saida.setValorTransacao(entradaApiTefC.getValorTransacao());
        } else if (entradaCTFClient.getValorTransacao() != null) {
            saida.setValorTransacao(entradaCTFClient.getValorTransacao());
        }
        this.validaSaidaCTFClient(saida);
        return saida;
    }

    private void validaSaidaCTFClient(SaidaCTFClient saida) {
        if (saida.getTaxaJuros() == null) {
            saida.setTaxaJuros(new BigDecimal(0));
        }
        if (saida.getValorParcela() == null) {
            saida.setValorParcela(new BigDecimal(0));
        }
        if (saida.getValorTransacao() == null) {
            saida.setValorTransacao(new BigDecimal(0));
        }
        if (saida.getValorTotal() == null) {
            saida.setValorTotal(new BigDecimal(0));
        }
        if (saida.getNomeVan() == null) {
            saida.setNomeVan("");
        }
        if (saida.getNomeCliente() == null) {
            saida.setNomeCliente("");
        }
        if (saida.getNomeOperacao() == null) {
            saida.setNomeOperacao("");
        }
        if (saida.getCodigoAprovacao() == null) {
            saida.setCodigoAprovacao("");
        }
        if (saida.getMensagemCTF() == null) {
            saida.setMensagemCTF(new String[]{""});
        }
    }

    static {
        confPerifericos = null;
        controladorPerifericos = null;
        controladorConfCTFClient = null;
        terminalManager = null;
    }

    class ExcecaoEntradaCTFClient
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int retorno;
        private String erro;
        private String[] mensagem;

        public ExcecaoEntradaCTFClient(int retorno, String erro, String[] mensagem) {
            this.retorno = retorno;
            this.erro = erro;
            this.mensagem = mensagem;
        }

        public String getErro() {
            return this.erro;
        }

        public void setErro(String erro) {
            this.erro = erro;
        }

        public String[] getMensagem() {
            return this.mensagem;
        }

        public void setMensagem(String[] msg) {
            this.mensagem = msg;
        }

        public int getRetorno() {
            return this.retorno;
        }

        public void setRetorno(int retorno) {
            this.retorno = retorno;
        }
    }
}

