/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import java.util.HashMap;
import java.util.Map;

public class ServicoCTF
extends Servico {
    private static final long serialVersionUID = 1L;
    private static Map protocolosCTF = new HashMap();
    private String protocolo;

    public ServicoCTF(Servico servico) throws ExcecaoParametroInvalido {
        this(servico.getHost(), servico.getIdentificadorServico());
    }

    public ServicoCTF(Host host, String identificador) throws ExcecaoParametroInvalido {
        this(host, identificador, null);
    }

    public ServicoCTF(Host host, String identificador, String protocolo) throws ExcecaoParametroInvalido {
        super(host, identificador);
        if (protocolo == null || protocolo.length() == 0) {
            if (identificador.equals("1996")) {
                this.setProtocolo("TCP");
            } else if (identificador.equals("1998")) {
                this.setProtocolo("UDP");
            } else if (identificador.equals("2000")) {
                this.setProtocolo("TCP2");
            }
        } else {
            this.setProtocolo(protocolo);
        }
    }

    public ServicoCTF(String servico) throws ExcecaoParametroInvalido {
        super(servico);
    }

    public void setProtocolo(String protocolo) throws ExcecaoParametroInvalido {
        if (protocolo == null || protocolosCTF.get(protocolo) == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        this.protocolo = protocolo;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public String getCodigoProtocolo() {
        return (String)protocolosCTF.get(this.getProtocolo());
    }

    @Override
    public String toString() {
        return this.getHost().toString() + ":" + this.getIdentificadorServico() + ":" + this.getProtocolo();
    }

    public boolean equals(ServicoCTF servico) {
        if (servico == null) {
            return false;
        }
        boolean retorno = this.getHost().equals(servico.getHost());
        retorno &= this.getIdentificadorServico().equals(servico.getIdentificadorServico());
        return retorno &= this.getProtocolo().equals(servico.getProtocolo());
    }

    static {
        protocolosCTF.put("TCP", "0");
        protocolosCTF.put("TCP2", "1");
        protocolosCTF.put("UDP", "3");
        protocolosCTF.put("HTTP", "4");
        protocolosCTF.put("HTTPS", "4");
    }
}

