/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoServidor;
import com.csi.ctfclient.tools.communication.access.TratadorDeConexoesDeEntrada;

public abstract class Servidor {
    protected int maxConexoes = 100;
    protected Servico servicoLocal = null;
    protected boolean servidorFinalizado = false;
    protected TratadorDeConexoesDeEntrada tratadorConexoes = null;

    public void finalizarServidor() {
        this.servidorFinalizado = true;
    }

    public Servidor(Servico local, TratadorDeConexoesDeEntrada tratador, int maxConexoes) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoServidor {
        if (local == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        if (tratador == null) {
            throw new ExcecaoParametroInvalido("COM031");
        }
        if (maxConexoes < 1) {
            throw new ExcecaoParametroInvalido("COM037");
        }
        this.servicoLocal = local;
        this.tratadorConexoes = tratador;
        this.maxConexoes = maxConexoes;
    }

    public int getMaxConexoes() {
        return this.maxConexoes;
    }
}

