/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorCartao;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class LeitorCartaoHandler
extends Periferico
implements ILeitorCartaoHandler {
    private String serial = null;
    private String msgCartao;
    private String msgPrompt;
    private ProtocoloBibliotecaCompartilhada protocolo = null;
    private LeitorCartaoBibliotecaCompartilhada leitorCartao = null;
    private int redeAdquirente = 0;
    private Integer indiceAID = null;

    public LeitorCartaoHandler(String serial, String msgCartao, String msgOcioso) throws ExcecaoPerifericos {
        this.serial = serial;
        this.msgCartao = msgCartao;
        this.msgPrompt = msgOcioso;
        this.protocolo = ProtocoloBibliotecaCompartilhada.getInstancia(serial);
        this.leitorCartao = new LeitorCartaoBibliotecaCompartilhada(this.protocolo);
        this.leitorCartao.setIdRedeAdquirente(this.redeAdquirente);
        this.leitorCartao.setIndiceAID(this.indiceAID);
    }

    @Override
    public LeitorCartao getLeitorCartao() {
        return this.leitorCartao;
    }

    @Override
    public int getRedeAdquirente() {
        return this.redeAdquirente;
    }

    @Override
    public void setRedeAdquirente(int redeAdquirente) {
        if (this.isBibliotecaCompartilhada()) {
            this.redeAdquirente = redeAdquirente;
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setIdRedeAdquirente(redeAdquirente);
        }
    }

    @Override
    public boolean isLeitura() {
        return this.leitorCartao != null && this.leitorCartao.isLeitura();
    }

    @Override
    public boolean isHabilitado() {
        return this.getHabilitado();
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.leitorCartao.habilita();
        this.setHabilitado(true);
    }

    @Override
    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido, ExcecaoPerifericos {
        this.leitorCartao.habilitaTrilha(numTrilha);
    }

    @Override
    public int getSolicitaCargaTabelas() {
        if (this.isBibliotecaCompartilhada()) {
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            return leitorCartaoEMV.getSolicitaCargaTabelas();
        }
        return LeitorCartaoEMV.CARGA_TABELA_OK;
    }

    @Override
    public void setSolicitaCargaTabelas(int atualizandoTabelas) {
        if (this.isBibliotecaCompartilhada()) {
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setSolicitaCargaTabelas(atualizandoTabelas);
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.leitorCartao.desabilita();
        this.setHabilitado(false);
    }

    @Override
    public void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        this.leitorCartao.addListener(ouvinte, utilizarBuffer);
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.leitorCartao.liberaRecursos();
    }

    @Override
    public void removeListener(PerifericoEntradaDadosListener ouvinte) {
        this.leitorCartao.removeListener(ouvinte);
    }

    @Override
    public long getTipoPeriferico() {
        return this.leitorCartao.getTipoPeriferico();
    }

    @Override
    public boolean isBibliotecaCompartilhada() {
        return ProtocoloBibliotecaCompartilhada.isBibliotecaEMV();
    }

    @Override
    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        return this.leitorCartao.iniciaCargaTabelas(timeStamp);
    }

    @Override
    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        return this.leitorCartao.executaCargaTabelas(tabela);
    }

    @Override
    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        return this.leitorCartao.finalizaCargaTabelas();
    }

    @Override
    public void setIndiceAID(Integer indiceAID) {
        if (this.isBibliotecaCompartilhada()) {
            this.indiceAID = indiceAID;
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setIndiceAID(indiceAID);
        }
    }

    @Override
    public Integer getIndiceAID() {
        return this.indiceAID;
    }
}

