/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.config;

import java.io.PrintWriter;
import java.io.Serializable;

public class ConfTipoDado
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INT = 0;
    public static final int REAL = 1;
    public static final int STR = 2;
    private int tipo;
    private double valMin;
    private double valMax;
    private double tamMax;
    private boolean valMinSetado = false;
    private boolean valMaxSetado = false;
    private boolean tamMaxSetado = false;
    private String descricao;
    private String[] valoresPossiveis;

    public ConfTipoDado(String descr, double tamMax, boolean usaTamMax, String[] valorespossiveis) {
        this.descricao = descr;
        this.tipo = 2;
        this.tamMaxSetado = usaTamMax;
        if (usaTamMax) {
            this.tamMax = tamMax;
        }
        if (usaTamMax) {
            this.tamMax = tamMax;
        }
        this.valMaxSetado = false;
        this.valMinSetado = false;
        this.valoresPossiveis = valorespossiveis;
    }

    public ConfTipoDado(String descr, int tipo, double valmin, boolean usaValMin, double valmax, boolean usaValMax, String[] valorespossiveis) {
        this.descricao = descr;
        this.tipo = tipo;
        this.valMaxSetado = usaValMax;
        this.valMinSetado = usaValMin;
        if (usaValMax) {
            this.valMax = valmax;
        }
        if (usaValMin) {
            this.valMin = valmin;
        }
        this.tamMaxSetado = false;
        this.valoresPossiveis = valorespossiveis;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public double getTamMax() {
        return this.tamMax;
    }

    public boolean getTamMaxSetado() {
        return this.tamMaxSetado;
    }

    public int getTipo() {
        return this.tipo;
    }

    public double getValMax() {
        return this.valMax;
    }

    public boolean getValMaxSetado() {
        return this.valMaxSetado;
    }

    public double getValMin() {
        return this.valMin;
    }

    public boolean getValMinSetado() {
        return this.valMinSetado;
    }

    public String[] getValoresPossiveis() {
        return this.valoresPossiveis;
    }

    private void identa(int tamIdent, PrintWriter writer) {
        for (int i = 0; i < tamIdent; ++i) {
            writer.print(' ');
        }
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setTamMax(double tamMax) {
        this.tamMax = tamMax;
        this.tamMaxSetado = true;
    }

    public void setValMax(double valMax) {
        this.valMax = valMax;
        this.valMaxSetado = true;
    }

    public void setValMin(double valMin) {
        this.valMin = valMin;
        this.valMinSetado = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Parametros [" + this.descricao + ", tipo=" + this.tipo + ", vmin=" + this.valMin + ", valmax=" + this.valMax + ", tammax=" + this.tamMax + "]\n");
        for (int i = 0; i < this.valoresPossiveis.length; ++i) {
            sb.append("   ");
            sb.append(this.valoresPossiveis[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void toXML(int ident, PrintWriter writer) {
        this.identa(ident + 3, writer);
        writer.write("<Params ");
        switch (this.tipo) {
            case 0: {
                writer.write("tipo=\"INT\" ");
                break;
            }
            case 1: {
                writer.write("tipo=\"REAL\" ");
                break;
            }
            case 2: {
                writer.write("tipo=\"STR\" ");
            }
        }
        if (this.descricao != null) {
            writer.write("descr=\"" + this.descricao + "\" ");
        }
        if ((this.tipo == 0 || this.tipo == 1) && this.valMinSetado) {
            writer.write("valmin=\"" + Double.toString(this.valMin) + "\" ");
        }
        if ((this.tipo == 0 || this.tipo == 1) && this.valMaxSetado) {
            writer.write("valmax=\"" + Double.toString(this.valMax) + "\" ");
        }
        if (this.tipo == 2 && this.tamMaxSetado) {
            writer.write("tammax=\"" + Double.toString(this.tamMax) + "\" ");
        }
        writer.write(">\n");
        if (this.valoresPossiveis.length > 0) {
            for (int i = 0; i < this.valoresPossiveis.length; ++i) {
                if (this.valoresPossiveis[i] == null) continue;
                this.identa(ident + 6, writer);
                writer.write("<ValoresPossiveis valor=\"" + this.valoresPossiveis[i] + "\" />\n");
            }
        }
        this.identa(ident + 3, writer);
        writer.write("</Params>\n");
    }

    private boolean valida(double valor) {
        if (this.valoresPossiveis.length == 0) {
            if (this.valMaxSetado && valor > this.valMax) {
                return false;
            }
            return !this.valMinSetado || !(valor < this.valMin);
        }
        for (int i = 0; i < this.valoresPossiveis.length; ++i) {
            if (valor != new Double(this.valoresPossiveis[i])) continue;
            return true;
        }
        return false;
    }

    private boolean valida(int valor) {
        if (this.valoresPossiveis.length == 0) {
            if (this.valMaxSetado && (double)valor > this.valMax) {
                return false;
            }
            return !this.valMinSetado || !((double)valor < this.valMin);
        }
        try {
            for (int i = 0; i < this.valoresPossiveis.length; ++i) {
                if (valor != new Integer(this.valoresPossiveis[i])) continue;
                return true;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    private boolean valida(String valor) {
        if (this.valoresPossiveis.length == 0) {
            return !this.tamMaxSetado || (double)valor.length() <= this.tamMax;
        }
        for (int i = 0; i < this.valoresPossiveis.length; ++i) {
            if (!valor.equalsIgnoreCase(this.valoresPossiveis[i])) continue;
            return true;
        }
        return false;
    }

    public boolean validaParametro(String parametro) {
        try {
            switch (this.tipo) {
                case 0: {
                    return this.valida(new Integer(parametro));
                }
                case 1: {
                    return this.valida(new Double(parametro));
                }
                case 2: {
                    return this.valida(parametro);
                }
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

