/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.File;

public class ControladorDetectaPinpad {
    private ILogger logger = CTFClientLogger.getPeriferico();
    private static ControladorDetectaPinpad controlador = null;

    private ControladorDetectaPinpad() {
    }

    public static ControladorDetectaPinpad getInstancia() {
        if (controlador == null) {
            controlador = new ControladorDetectaPinpad();
        }
        return controlador;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detectaPinpad(ControladorPerifericos perifericos) throws ExcecaoPerifericos {
        try {
            File fileSERCFG;
            this.logger.info("iniciando rotina de verificacao de pinpad");
            File fileCSICFG = new File("CSICFG");
            if (fileCSICFG.exists()) {
                fileCSICFG.delete();
            }
            if ((fileSERCFG = new File("SERCFG")).exists()) {
                fileSERCFG.delete();
            }
            String osName = System.getProperty("os.name");
            String tipoPorta = "";
            String portaSerial = "";
            if (osName.toUpperCase().indexOf("WIN") != -1) {
                tipoPorta = "COM";
            } else {
                try {
                    ConfCTFClient configClient = ControladorConfCTFClient.getInstance().getConfig();
                    ConfPeriferico confPeriferico = configClient.getPin();
                    String[] params = confPeriferico.getParametros();
                    tipoPorta = params[0].substring(0, params[0].length() - 1);
                }
                catch (Exception configClient) {
                    // empty catch block
                }
            }
            try {
                ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                boolean multiEC = config.isMultiEC();
                IdentTerminal identTerminal = null;
                identTerminal = entradaIntegracao != null && multiEC ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
                if (dadosInicioDia.getTipoBibliotecaPinpad() == 0) {
                    ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(1);
                } else {
                    ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(dadosInicioDia.getTipoBibliotecaPinpad());
                }
            }
            catch (ExcecaoApiAc e1) {
                this.logger.error("nao foi possivel recuperar o tipo da biblioteca de pinpad.");
            }
            int i = 1;
            int pausa = 0;
            for (i = 0; i <= 99; ++i) {
                if (++pausa == 10) {
                    LayoutMenu layoutMenu = new LayoutMenu("CONTINUAR VERIFICACAO?", true);
                    layoutMenu.addItem(new ItemMenu("SIM", "1"));
                    layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    int opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1 || opcao != 1) break;
                    pausa = 0;
                }
                portaSerial = tipoPorta + i;
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("VERIFICANDO PINPAD"));
                layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                layoutDisplay.addLinha(new Linha("AGUARDE..."));
                perifericos.imprimeDisplay(layoutDisplay);
                ProtocoloBibliotecaCompartilhada protocolo = ProtocoloBibliotecaCompartilhada.getInstancia(portaSerial);
                try {
                    protocolo.testarComunicacao();
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.setDelay(1500L);
                    layoutDisplay.addLinha(new Linha("PINPAD DETECTADO"));
                    layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                    perifericos.imprimeDisplay(layoutDisplay);
                    protocolo.fecharComunicacao();
                    break;
                }
                catch (Exception e) {
                    this.logger.error("pinpad nao localizado na porta " + i);
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.setDelay(1500L);
                    layoutDisplay.addLinha(new Linha("PINPAD NAO DETECTADO"));
                    layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                    perifericos.imprimeDisplay(layoutDisplay);
                    portaSerial = null;
                    continue;
                }
                finally {
                    ProtocoloBibliotecaCompartilhada.finaliza();
                }
            }
            return portaSerial;
        }
        catch (ExcecaoNaoLocal e) {
            throw new ExcecaoPerifericos(null, e.getMessage());
        }
    }
}

