/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.DisplayFisico;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import javax.swing.JFrame;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbIrp;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;

public class DisplayFisicoAuttar
extends DisplayFisico {
    private static byte CMD_DISPLAY_CLEAR = (byte)20;
    private static byte CMD_DISPLAY_GOTOXY = (byte)23;
    private static byte CMD_DISPLAY_STRING = (byte)25;
    private static byte CMD_DISPLAY_CHANGE_CURSOR = (byte)31;
    private boolean displayVazio = false;
    private DisplayGertecTecladoUSBDLL dispDLL = null;
    private UsbInterface usbInt;
    private UsbPipe usbPipe;

    private UsbDevice procuraDispUsb(UsbHub hub, short vendorId, short productId) {
        List devices = hub.getAttachedUsbDevices();
        for (UsbDevice device : devices) {
            UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
            if (desc.idVendor() == vendorId && desc.idProduct() == productId) {
                return device;
            }
            if (!device.isUsbHub() || (device = this.procuraDispUsb((UsbHub)device, vendorId, productId)) == null) continue;
            return device;
        }
        return null;
    }

    private void abrePipe() throws Exception {
        block7: {
            try {
                this.usbPipe.open();
            }
            catch (Exception e) {
                try {
                    this.desabilita();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean usbFixed = false;
                try {
                    this.inicializa();
                    if (this.usbInt != null && this.usbInt.isClaimed()) {
                        usbFixed = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (usbFixed) break block7;
                throw new Exception("Impossivel abrir pipe com o teclado (msg = '" + e.getMessage() + "')!");
            }
        }
    }

    private void enviaComando(byte[] cmd) throws Exception {
        try {
            this.abrePipe();
            UsbIrp irp = this.usbPipe.createUsbIrp();
            byte[] rawCmd = new byte[32];
            if (cmd.length <= 22) {
                System.arraycopy(cmd, 0, rawCmd, 0, cmd.length);
            } else {
                System.arraycopy(cmd, 0, rawCmd, 0, 22);
            }
            irp.setData(rawCmd);
            irp.setLength(rawCmd.length);
            irp.setActualLength(rawCmd.length);
            irp.setAcceptShortPacket(true);
            this.usbPipe.syncSubmit(irp);
            this.fechaPipe();
        }
        catch (Exception e) {
            throw new Exception("Impossivel enviar comando (msg = '" + e.getMessage() + "')!");
        }
    }

    private void fechaPipe() {
        try {
            this.usbPipe.close();
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    private void inicializa() throws ExcecaoPerifericos {
        String msgDbg = "DisplayGertecTecladoUSB::inicializa() -> ";
        BufferedWriter bw = null;
        try {
            File f = new File("javax.usb.properties");
            if (f.exists()) {
                f.delete();
            }
            bw = new BufferedWriter(new FileWriter(f));
            bw.write("javax.usb.services = de.ailis.usb4java.Services");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(msgDbg + "Impossivel escrever arquivo 'javax.usb.properties'!");
        }
        try {
            UsbServices services = UsbHostManager.getUsbServices();
            UsbHub rootHub = services.getRootUsbHub();
            UsbDevice usbDev = this.procuraDispUsb(rootHub, (short)5971, (short)257);
            if (usbDev == null) {
                System.out.println(msgDbg + "Teclado Gertec USB desconectado!");
                throw new ExcecaoPerifericos(this, "PER21");
            }
            System.out.println(msgDbg + "Teclado Gertec USB conectado.");
            List interfaces = usbDev.getActiveUsbConfiguration().getUsbInterfaces();
            this.usbInt = (UsbInterface)interfaces.get(1);
            if (this.usbInt == null) {
                System.out.println(msgDbg + "Interface USB Teclado Gertec nao encontrada!");
                throw new ExcecaoPerifericos(this, "PER21");
            }
            try {
                this.usbInt.claim();
            }
            catch (UsbException uE) {
                System.out.println(msgDbg + "Impossivel requisitar interface USB Teclado Gertec!");
                throw new ExcecaoPerifericos(this, "PER21");
            }
            List usbEndpoints = this.usbInt.getUsbEndpoints();
            UsbEndpoint usbEndpoint = null;
            for (int i = 0; i < usbEndpoints.size() && ((usbEndpoint = (UsbEndpoint)usbEndpoints.get(i)).getType() != 3 || usbEndpoint.getDirection() != 0); ++i) {
                usbEndpoint = null;
            }
            if (usbEndpoint == null) {
                System.out.println(msgDbg + "A interface USB Teclado Gertec nao possui o endpoint de saida via interrupcao!");
                throw new ExcecaoPerifericos(this, "PER21");
            }
            this.usbPipe = usbEndpoint.getUsbPipe();
        }
        catch (UsbException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", (Exception)((Object)e));
        }
    }

    public DisplayFisicoAuttar(String a, String b, String c, String d) throws ExcecaoPerifericos {
        this("40", "20");
    }

    public DisplayFisicoAuttar(JFrame f, String a, String b, String c, String d) throws ExcecaoPerifericos {
        this("40", "20");
    }

    public DisplayFisicoAuttar(String numColunas, String numLinhas) throws ExcecaoPerifericos {
        if (System.getProperty("os.name").equalsIgnoreCase("LINUX")) {
            this.inicializa();
            this.numColunas = Integer.parseInt(numColunas);
            this.numLinhas = Integer.parseInt(numLinhas);
            this.habilita();
            this.limpa();
            this.desabilita();
        } else {
            this.dispDLL = new DisplayGertecTecladoUSBDLL(numColunas, numLinhas);
        }
    }

    public static void main(String[] args) {
        try {
            DisplayFisicoAuttar display = new DisplayFisicoAuttar("40", "2");
            display.habilita();
            System.out.println("Iniciando testes (limpa, posiciona e imprime)...");
            for (int ct = 0; ct < 9999; ++ct) {
                int lastExecuted = 0;
                try {
                    display.limpa();
                    Thread.sleep(500L);
                    lastExecuted = 1;
                    display.posicionaCursor(0, 0);
                    lastExecuted = 2;
                    display.imprime("LI00, CO00 - " + ct);
                    Thread.sleep(250L);
                    lastExecuted = 1;
                    display.posicionaCursor(1, 0);
                    lastExecuted = 2;
                    display.imprime("LI01, CO00 - " + ct);
                    Thread.sleep(250L);
                    lastExecuted = 1;
                    display.posicionaCursor(0, 20);
                    lastExecuted = 2;
                    display.imprime("LI00, CO20 - " + ct);
                    Thread.sleep(250L);
                    lastExecuted = 1;
                    display.posicionaCursor(1, 20);
                    lastExecuted = 2;
                    display.imprime("LI01, CO20 - " + ct);
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (lastExecuted == 0) {
                        System.out.println("ERRO: excecao no limpa()");
                    } else if (lastExecuted == 1) {
                        System.out.println("ERRO: excecao no posicionaCursor()");
                    } else if (lastExecuted == 2) {
                        System.out.println("ERRO: excecao no imprime()");
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            display.limpa();
            display.desabilita();
            display.liberaRecursos();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.desabilita();
            return;
        }
        try {
            this.usbInt.release();
            this.setHabilitado(false);
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER02", e);
        }
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.habilita();
            return;
        }
        try {
            if (!this.usbInt.isClaimed()) {
                this.usbInt.claim();
            }
            this.setHabilitado(true);
            this.displayVazio = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExcecaoPerifericos((Periferico)this, "PER01", e);
        }
    }

    @Override
    public void imprime(String texto) throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.imprime(texto);
            return;
        }
        this.imprimeEm(this.linhaAtual, this.colunaAtual, texto);
    }

    @Override
    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        int tamTexto = texto.length();
        if (tamTexto <= 0) {
            return;
        }
        int tamMax = (this.numLinhas - linha - 1) * this.numColunas + (this.numColunas - coluna);
        if (tamTexto > tamMax) {
            texto = texto.substring(0, tamMax);
        }
        if (this.dispDLL != null) {
            this.dispDLL.imprimeEm(linha, coluna, texto);
            return;
        }
        try {
            boolean branco = texto.trim().equals("");
            if (!this.displayVazio || !branco) {
                if (linha != this.linhaAtual || coluna != this.colunaAtual) {
                    this.posicionaCursor(linha, coluna);
                }
                int ct = 0;
                while (0 + ct * 20 < tamMax && 0 + ct * 20 < tamTexto) {
                    int curLen = texto.substring(0 + ct * 20).length();
                    byte[] cmd = new byte[(curLen > 20 ? 20 : curLen) + 2];
                    cmd[0] = CMD_DISPLAY_STRING;
                    cmd[1] = (byte)(cmd.length - 2);
                    System.arraycopy(texto.getBytes(), 0 + ct * 20, cmd, 2, cmd.length - 2);
                    ++ct;
                    this.enviaComando(cmd);
                }
            }
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            this.reposiciona(texto);
            if (!branco) {
                this.displayVazio = false;
            }
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER24", e);
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.liberaRecursos();
            return;
        }
        if (this.getHabilitado()) {
            this.desabilita();
        }
    }

    @Override
    public void limpa() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.limpa();
            return;
        }
        try {
            if (!this.displayVazio) {
                try {
                    this.enviaComando(new byte[]{CMD_DISPLAY_CHANGE_CURSOR, 2, 0, 0});
                }
                catch (Exception e) {
                    System.out.println("Ocorreu um erro ao desabilitar a exibi\u00e7\u00e3o do cursor!");
                    System.out.println("Detalhes: " + e.getMessage());
                }
                this.enviaComando(new byte[]{CMD_DISPLAY_CLEAR, 0});
            }
            this.colunaAtual = 0;
            this.linhaAtual = 0;
            this.limpaTexto();
            this.displayVazio = true;
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER23", e);
        }
    }

    @Override
    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.posicionaCursor(linha, coluna);
            return;
        }
        if (linha == this.linhaAtual && coluna == this.colunaAtual) {
            return;
        }
        try {
            this.enviaComando(new byte[]{CMD_DISPLAY_GOTOXY, 2, (byte)coluna, (byte)linha});
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER23", e);
        }
    }

    static interface GertecLibrary
    extends Library {
        public int OpenTec65();

        public void CloseTec65();

        public void DispStr(String var1);

        public void GoToXY(int var1, int var2);

        public void LcdClearLine(int var1);

        public void ModoCursor(int var1);
    }

    class DisplayGertecTecladoUSBDLL
    extends DisplayFisico {
        private GertecLibrary gertecRef = null;

        private void inicializa() throws ExcecaoPerifericos {
            int opened = this.gertecRef.OpenTec65();
            if (opened != 0) {
                throw new ExcecaoPerifericos(this, "PER21");
            }
        }

        public DisplayGertecTecladoUSBDLL(String numColunas, String numLinhas) throws ExcecaoPerifericos {
            this.habilita();
            this.inicializa();
            this.numLinhas = Integer.parseInt(numLinhas);
            this.numColunas = Integer.parseInt(numColunas);
            this.limpa();
            this.desabilita();
        }

        @Override
        public void imprime(String texto) throws ExcecaoPerifericos {
            System.out.println("linhaAtual=" + this.linhaAtual + " / colunaAtual=" + this.colunaAtual + " / texto=" + texto);
            this.imprimeEm(this.linhaAtual, this.colunaAtual, texto);
        }

        @Override
        public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
            boolean branco = texto.trim().equals("");
            if (!DisplayFisicoAuttar.this.displayVazio || !branco) {
                if (linha != this.linhaAtual || coluna != this.colunaAtual) {
                    this.posicionaCursor(linha, coluna);
                }
                this.gertecRef.DispStr(texto);
            }
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            this.reposiciona(texto);
            if (!branco) {
                DisplayFisicoAuttar.this.displayVazio = false;
            }
        }

        @Override
        public void limpa() throws ExcecaoPerifericos {
            if (!DisplayFisicoAuttar.this.displayVazio) {
                this.gertecRef.ModoCursor(0);
                this.gertecRef.LcdClearLine(1);
                this.gertecRef.LcdClearLine(2);
                this.gertecRef.GoToXY(1, 1);
            }
            this.colunaAtual = 0;
            this.linhaAtual = 0;
            this.limpaTexto();
            DisplayFisicoAuttar.this.displayVazio = true;
        }

        @Override
        public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
            if (linha == this.linhaAtual && coluna == this.colunaAtual) {
                return;
            }
            this.gertecRef.GoToXY(linha + 1, coluna + 1);
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
        }

        @Override
        public void desabilita() throws ExcecaoPerifericos {
            this.gertecRef.CloseTec65();
            this.gertecRef = null;
            System.gc();
            this.setHabilitado(false);
        }

        @Override
        public void habilita() throws ExcecaoPerifericos {
            if (this.gertecRef == null) {
                this.gertecRef = (GertecLibrary)Native.loadLibrary((String)"tec65_32", GertecLibrary.class);
            }
            this.inicializa();
            this.setHabilitado(true);
            DisplayFisicoAuttar.this.displayVazio = false;
        }

        @Override
        public void liberaRecursos() throws ExcecaoPerifericos {
            if (this.getHabilitado()) {
                this.desabilita();
            }
        }
    }
}

