/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.postef.POSTefHandler;
import com.csi.ctfclient.tools.devices.postef.POSTefListener;
import com.csi.ctfclient.tools.devices.postef.ProvedorMensagemHandler;
import com.csi.ctfclient.tools.devices.postef.model.RegistroPagamento;
import com.csi.ctfclient.tools.devices.postef.model.TipoMensagem;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.lang.reflect.Constructor;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class POSTef<ProvedorMensagem extends ProvedorMensagemHandler<?>>
extends Thread {
    protected ILogger log = CTFClientLogger.getPeriferico();
    private RegistroPagamento pagamentoPendente;
    private POSTefListener posTefListener = null;
    private String timestampPagamento;
    private static Class<? extends POSTef<?>> tipoPOSMovel;
    private static POSTef<?> posMovel;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private boolean habilitado = false;

    public static <Type extends POSTef<?>> void init(Class<Type> tipo) {
        tipoPOSMovel = tipo;
    }

    public static POSTef<?> getInstance() {
        if (posMovel == null) {
            posMovel = POSTef.factory(tipoPOSMovel);
        }
        return posMovel;
    }

    public abstract void conecta();

    private static <T extends POSTef<?>> POSTef<?> factory(Class<T> type) throws IllegalArgumentException {
        try {
            Class<?> clazz = Class.forName(type.getName());
            Constructor<?> cons = clazz.getConstructor(new Class[0]);
            return (POSTef)cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected RegistroPagamento getPagamentoPendente() {
        return this.pagamentoPendente;
    }

    public void reset() {
        this.pagamentoPendente = null;
        this.setTimestampPagamento(null);
    }

    protected <T extends POSTefHandler> void execute(T handler) {
        this.executor.execute(handler);
    }

    public void desconecta() throws ExcecaoPerifericos {
        this.setInicializado(false);
    }

    public boolean isInicializado() {
        return this.habilitado;
    }

    public void setInicializado(boolean habilitado) {
        this.habilitado = habilitado;
    }

    public String getTimestampPagamento() {
        return this.timestampPagamento;
    }

    public void setTimestampPagamento(String timeStampPinpadRemoto) {
        this.timestampPagamento = timeStampPinpadRemoto;
    }

    public synchronized void registrarPagamento(RegistroPagamento pagamentoPendente, POSTefListener posTefListener) {
        this.posTefListener = posTefListener;
        this.pagamentoPendente = pagamentoPendente;
    }

    public POSTefListener getPosTefListener() {
        return this.posTefListener;
    }

    protected final void handler(ProvedorMensagem provedorMensagem) {
        try {
            TipoMensagem tipoMensagem = ((ProvedorMensagemHandler)provedorMensagem).getTipoMensagem();
            if (tipoMensagem.equals((Object)TipoMensagem.pagamento_postef)) {
                this.handlerPagamentoPOSTef(provedorMensagem);
            } else if (tipoMensagem.equals((Object)TipoMensagem.resposta_pagamento_postef)) {
                this.handlerResultadoPagamento(provedorMensagem);
            }
        }
        catch (Exception e) {
            this.log.error("processaRequisicao: ", e);
        }
    }

    protected synchronized void handlerPagamentoPOSTef(ProvedorMensagem provedorMensagem) {
        if (this.pagamentoPendente != null) {
            String uuid = UUID.randomUUID().toString();
            this.setTimestampPagamento(uuid);
        }
    }

    protected synchronized void handlerResultadoPagamento(ProvedorMensagem messageManager) {
    }
}

