/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef.wifi;

import com.csi.ctfclient.tools.devices.postef.ConsultaPagamentoPOSTefHandler;
import com.csi.ctfclient.tools.devices.postef.ProvedorMensagemHandler;
import com.csi.ctfclient.tools.devices.postef.model.RegistroPagamento;
import com.csi.ctfclient.tools.devices.postef.wifi.ProtocoloBuilder;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.SimpleDateFormat;

public class ConsultaPagamentoPOSTefWifi
extends ConsultaPagamentoPOSTefHandler {
    public ConsultaPagamentoPOSTefWifi(ProvedorMensagemHandler<?> messageManager, RegistroPagamento registroPagamento, String timeStamp) {
        super(messageManager, registroPagamento, timeStamp);
    }

    @Override
    protected void handler() {
        SimpleDateFormat formatoData = new SimpleDateFormat("yyyyMMdd");
        String dataAbertura = formatoData.format(this.getRegistroPagamento().getDataAbertura());
        ProtocoloBuilder protocoloBuilder = new ProtocoloBuilder("0100", 0).setSubCampo("7000", "00").setSubCampo("7802", dataAbertura);
        if (this.getRegistroPagamento().getValorTransacao() != null) {
            protocoloBuilder.setSubCampo("7005", StringUtil.sprintf("%012d", new Object[]{this.getRegistroPagamento().getValorTransacao()}));
        }
        if (this.getRegistroPagamento().getNumeroParcelas() != null) {
            protocoloBuilder.setSubCampo("7008", StringUtil.sprintf("%02d", new Object[]{new Integer(this.getRegistroPagamento().getNumeroParcelas())}));
        }
        if (this.getRegistroPagamento().getDocumento() != null) {
            protocoloBuilder.setSubCampo("7020", this.getRegistroPagamento().getDocumento());
        }
        protocoloBuilder.setSubCampo("7079", this.getTimeStamp());
        ((ProvedorMensagemHandler)this.getGerenciadorMensagem()).enviar((byte[])protocoloBuilder.build());
    }

    @Override
    protected void handlerError() {
        try {
            log.info("nao existe transacao para processamento remoto.");
        }
        catch (Exception e) {
            log.error("erro no processamento da resposta de transacao invalida para operacao 904.", e);
        }
    }
}

