/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoDadoInvalido;
import com.csi.ctfclient.info.tiposgerais.Chave;
import com.csi.ctfclient.info.tiposgerais.ChaveString;
import com.csi.ctfclient.info.tiposgerais.Persistente;
import com.csi.ctfclient.tools.util.CSIBigDecimal;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.Locale;

public class ParametrosInternacionalizacao
implements Persistente {
    private static final long serialVersionUID = 1L;
    private String localidade = "br";
    private String padraoIntervalo = "HH:mm";
    private String lingua = "pt";
    private String padraoHora = "HH:mm:ss";
    private String padraoData = new String("dd/mm/yyyy");
    private String padraoNumero = "ZZZ.ZZZ.ZZ9,99";
    private String separadorDecimal = ",";
    private String separadorGrupo = ".";
    private static String PERCENTUAL = "%";

    public ParametrosInternacionalizacao() {
    }

    public ParametrosInternacionalizacao(ParametrosInternacionalizacao p) {
        this.padraoHora = new String(p.getPadraoHora());
        this.padraoData = new String(p.getPadraoData());
        this.padraoNumero = new String(p.getPadraoNumero());
        this.separadorDecimal = new String(p.getSeparadorDecimal());
        this.separadorGrupo = new String(p.getSeparadorGrupo());
        this.localidade = new String(p.getLocalidade());
        this.lingua = new String(p.getLingua());
    }

    public ParametrosInternacionalizacao(String pHora, String pData, String pNum, String sepDec, String sepGrupo, String ling, String loc) {
        this.padraoHora = pHora;
        this.padraoData = pData;
        this.padraoNumero = pNum;
        this.separadorDecimal = sepDec;
        this.separadorGrupo = sepGrupo;
        this.localidade = loc;
        this.lingua = ling;
    }

    public CSIBigDecimal arredonda(CSIBigDecimal num) {
        int casasDecimais = this.getNumCasasDecimal();
        CSIBigDecimal d = num;
        if (num.lesser(CSIBigDecimal.getZero())) {
            d = num.negative();
        }
        CSIBigDecimal res = d.setScale(casasDecimais, 4);
        return res;
    }

    public int comparaString(String str1, String str2) {
        Collator col = Collator.getInstance(this.getLocale());
        return col.compare(str1, str2);
    }

    public String formataPercentualSimples(CSIBigDecimal percentual) {
        String strPercentual = percentual.toString();
        String separador = this.getSeparadorDecimal();
        String simbPercentual = PERCENTUAL;
        int qtdCasas = 2;
        int indiceSeparador = strPercentual.indexOf(".");
        String parteInteira = "";
        String parteDecimal = "";
        String resultado = "";
        if (indiceSeparador == -1) {
            parteInteira = strPercentual;
            for (int i = 0; i < qtdCasas; ++i) {
                parteDecimal = parteDecimal + "0";
            }
        } else {
            parteInteira = strPercentual.substring(0, indiceSeparador);
            if (strPercentual.length() - indiceSeparador < qtdCasas) {
                int quantoFalta = qtdCasas - (strPercentual.length() - (indiceSeparador + 1));
                parteDecimal = strPercentual.substring(indiceSeparador + 1, strPercentual.length());
                for (int i = 0; i < quantoFalta; ++i) {
                    parteDecimal = parteDecimal + "0";
                }
            } else {
                parteDecimal = strPercentual.substring(indiceSeparador + 1, indiceSeparador + 1 + qtdCasas);
            }
        }
        resultado = parteInteira + separador + parteDecimal + simbPercentual;
        return resultado;
    }

    @Override
    public Chave getChave() {
        return new ChaveString(this.getLocalidade() + "_" + this.getLingua());
    }

    @Override
    public String getChaveString() {
        return this.getLocalidade() + "_" + this.getLingua();
    }

    public String getLingua() {
        return this.lingua;
    }

    public Locale getLocale() {
        return new Locale(this.lingua, this.localidade);
    }

    public String getLocalidade() {
        return this.localidade;
    }

    public int getNumCasasDecimal() {
        int inicio = this.getPadraoNumero().indexOf(this.getSeparadorDecimal());
        int res = 0;
        for (int i = ++inicio; i < this.getPadraoNumero().length(); ++i) {
            if (this.getPadraoNumero().charAt(i) == ' ') continue;
            ++res;
        }
        return res;
    }

    public String getPadraoData() {
        return this.padraoData;
    }

    public String getPadraoHora() {
        return this.padraoHora;
    }

    public String getPadraoIntervalo() {
        return this.padraoIntervalo;
    }

    public String getPadraoNumero() {
        return this.padraoNumero;
    }

    public String getSeparadorDecimal() {
        return this.separadorDecimal;
    }

    public String getSeparadorGrupo() {
        return this.separadorGrupo;
    }

    public void imprimeTeste() {
        System.out.println("\nIniciando o metodo imprimeTeste():");
        System.out.println("Hora Padrao = " + this.padraoHora);
        System.out.println("Data Padrao = " + this.padraoData);
        System.out.println("Numero Padrao = " + this.padraoNumero);
        System.out.println("Separador Decimal = " + this.separadorDecimal);
        System.out.println("Separador de Grupo = " + this.separadorGrupo);
        System.out.println("Localidade = " + this.localidade);
        System.out.println("Lingua = " + this.lingua);
    }

    public String numeroToString(CSIBigDecimal valor) {
        int i;
        int i2;
        int digitoObrigatorio = 57;
        int digitoOpcional = 90;
        int sepDecimais = 44;
        int sepDeGrupo = 46;
        boolean mascaraTemSeparadorDecimal = false;
        boolean mascaraTemSeparadorDeGrupo = false;
        int nDigitosOpcionaisEsquerda = 0;
        int nDigitosOpcionaisDireita = 0;
        int nMascaraDecimais = 0;
        int comecoNumero = 0;
        int fimNumero = this.padraoNumero.length() - 1;
        boolean cortaZerosAEsquerda = false;
        boolean cortaZerosADireita = false;
        int posDigObrigatorio = this.padraoNumero.indexOf(57);
        int posDigOpcional = this.padraoNumero.indexOf(90);
        if (posDigOpcional == -1) {
            comecoNumero = posDigObrigatorio;
        } else if (posDigObrigatorio == -1) {
            comecoNumero = posDigOpcional;
            cortaZerosAEsquerda = true;
        } else if (posDigObrigatorio < posDigOpcional) {
            comecoNumero = posDigObrigatorio;
        } else {
            comecoNumero = posDigOpcional;
            cortaZerosAEsquerda = true;
        }
        posDigObrigatorio = this.padraoNumero.lastIndexOf(57);
        posDigOpcional = this.padraoNumero.lastIndexOf(90);
        if (posDigOpcional == -1) {
            fimNumero = posDigObrigatorio;
        } else if (posDigObrigatorio == -1) {
            fimNumero = posDigOpcional;
            cortaZerosADireita = true;
        } else if (posDigOpcional > posDigObrigatorio) {
            fimNumero = posDigOpcional;
            cortaZerosADireita = true;
        } else {
            fimNumero = posDigObrigatorio;
        }
        String prefixo = comecoNumero == 0 ? "" : this.padraoNumero.substring(0, comecoNumero);
        String sufixo = fimNumero == this.padraoNumero.length() - 1 ? "" : this.padraoNumero.substring(fimNumero + 1);
        String meio = this.padraoNumero.substring(comecoNumero, fimNumero + 1);
        for (int i3 = 0; i3 < meio.length(); ++i3) {
            if (meio.charAt(i3) == ',') {
                mascaraTemSeparadorDecimal = true;
                continue;
            }
            if (mascaraTemSeparadorDecimal) {
                ++nMascaraDecimais;
                if (meio.charAt(i3) != 'Z') continue;
                ++nDigitosOpcionaisDireita;
                continue;
            }
            if (meio.charAt(i3) == 'Z') {
                ++nDigitosOpcionaisEsquerda;
                continue;
            }
            if (meio.charAt(i3) != '.') continue;
            mascaraTemSeparadorDeGrupo = true;
            ++nDigitosOpcionaisEsquerda;
        }
        String numero = "";
        numero = mascaraTemSeparadorDecimal && mascaraTemSeparadorDeGrupo ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), this.getSeparadorDecimal(), this.getSeparadorGrupo(), 2) : (mascaraTemSeparadorDecimal ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), this.getSeparadorDecimal(), "", 2) : (mascaraTemSeparadorDeGrupo ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), "", this.getSeparadorGrupo(), 2) : StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), "", "", 2)));
        if (cortaZerosADireita) {
            for (i2 = 1; i2 <= nDigitosOpcionaisDireita && numero.charAt(numero.length() - 1) == '0'; ++i2) {
                numero = numero.substring(0, numero.length() - 1);
            }
        }
        String sinal = "";
        if (cortaZerosAEsquerda) {
            if (numero.charAt(0) == '-' && nDigitosOpcionaisEsquerda > 0) {
                --nDigitosOpcionaisEsquerda;
            }
            for (i2 = 0; i2 < nDigitosOpcionaisEsquerda; ++i2) {
                if (numero.charAt(0) == '-') {
                    sinal = "-";
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) == '0') {
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) == this.getSeparadorGrupo().charAt(0)) {
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) != '0') break;
            }
        }
        if (mascaraTemSeparadorDeGrupo) {
            int indicePrimSeparador = 0;
            indicePrimSeparador = mascaraTemSeparadorDecimal ? numero.length() - 1 - nMascaraDecimais - 4 : numero.length() - 1 - nMascaraDecimais - 3;
            for (i = indicePrimSeparador; i > 0; i -= 4) {
                if (numero.charAt(i) != '0') continue;
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append(numero.substring(0, i));
                sbuffer.append(this.getSeparadorGrupo());
                sbuffer.append(numero.substring(i + 1));
                numero = sbuffer.toString();
            }
        }
        if (meio.length() < numero.length()) {
            StringBuffer numGrande = new StringBuffer();
            for (i = 0; i < meio.length(); ++i) {
                numGrande.append('*');
            }
            numero = numGrande.toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefixo);
        buf.append(sinal);
        buf.append(numero);
        buf.append(sufixo);
        String resultado = buf.toString();
        return resultado;
    }

    public String numeroToString(CSIBigDecimal valor, String mask) {
        int i;
        int i2;
        int digitoObrigatorio = 57;
        int digitoOpcional = 90;
        int sepDecimais = 44;
        int sepDeGrupo = 46;
        boolean mascaraTemSeparadorDecimal = false;
        boolean mascaraTemSeparadorDeGrupo = false;
        int nDigitosOpcionaisEsquerda = 0;
        int nDigitosOpcionaisDireita = 0;
        int nMascaraDecimais = 0;
        int comecoNumero = 0;
        int fimNumero = mask.length() - 1;
        boolean cortaZerosAEsquerda = false;
        boolean cortaZerosADireita = false;
        int posDigObrigatorio = mask.indexOf(57);
        int posDigOpcional = mask.indexOf(90);
        if (posDigOpcional == -1) {
            comecoNumero = posDigObrigatorio;
        } else if (posDigObrigatorio == -1) {
            comecoNumero = posDigOpcional;
            cortaZerosAEsquerda = true;
        } else if (posDigObrigatorio < posDigOpcional) {
            comecoNumero = posDigObrigatorio;
        } else {
            comecoNumero = posDigOpcional;
            cortaZerosAEsquerda = true;
        }
        posDigObrigatorio = mask.lastIndexOf(57);
        posDigOpcional = mask.lastIndexOf(90);
        if (posDigOpcional == -1) {
            fimNumero = posDigObrigatorio;
        } else if (posDigObrigatorio == -1) {
            fimNumero = posDigOpcional;
            cortaZerosADireita = true;
        } else if (posDigOpcional > posDigObrigatorio) {
            fimNumero = posDigOpcional;
            cortaZerosADireita = true;
        } else {
            fimNumero = posDigObrigatorio;
        }
        String prefixo = comecoNumero == 0 ? "" : mask.substring(0, comecoNumero);
        String sufixo = fimNumero == mask.length() - 1 ? "" : mask.substring(fimNumero + 1);
        String meio = mask.substring(comecoNumero, fimNumero + 1);
        for (int i3 = 0; i3 < meio.length(); ++i3) {
            if (meio.charAt(i3) == ',') {
                mascaraTemSeparadorDecimal = true;
                continue;
            }
            if (mascaraTemSeparadorDecimal) {
                ++nMascaraDecimais;
                if (meio.charAt(i3) != 'Z') continue;
                ++nDigitosOpcionaisDireita;
                continue;
            }
            if (meio.charAt(i3) == 'Z') {
                ++nDigitosOpcionaisEsquerda;
                continue;
            }
            if (meio.charAt(i3) != '.') continue;
            mascaraTemSeparadorDeGrupo = true;
            ++nDigitosOpcionaisEsquerda;
        }
        String numero = "";
        numero = mascaraTemSeparadorDecimal && mascaraTemSeparadorDeGrupo ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), this.getSeparadorDecimal(), this.getSeparadorGrupo(), 2) : (mascaraTemSeparadorDecimal ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), this.getSeparadorDecimal(), "", 2) : (mascaraTemSeparadorDeGrupo ? StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), "", this.getSeparadorGrupo(), 2) : StringUtil.numeroToString(valor, nMascaraDecimais, meio.length(), "", "", 2)));
        if (cortaZerosADireita) {
            for (i2 = 1; i2 <= nDigitosOpcionaisDireita && numero.charAt(numero.length() - 1) == '0'; ++i2) {
                numero = numero.substring(0, numero.length() - 1);
            }
        }
        String sinal = "";
        if (cortaZerosAEsquerda) {
            if (numero.charAt(0) == '-' && nDigitosOpcionaisEsquerda > 0) {
                --nDigitosOpcionaisEsquerda;
            }
            for (i2 = 0; i2 < nDigitosOpcionaisEsquerda; ++i2) {
                if (numero.charAt(0) == '-') {
                    sinal = "-";
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) == '0') {
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) == this.getSeparadorGrupo().charAt(0)) {
                    numero = numero.substring(1);
                }
                if (numero.charAt(0) != '0') break;
            }
        }
        if (mascaraTemSeparadorDeGrupo) {
            int indicePrimSeparador = 0;
            indicePrimSeparador = mascaraTemSeparadorDecimal ? numero.length() - 1 - nMascaraDecimais - 4 : numero.length() - 1 - nMascaraDecimais - 3;
            for (i = indicePrimSeparador; i > 0; i -= 4) {
                if (numero.charAt(i) != '0') continue;
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append(numero.substring(0, i));
                sbuffer.append(this.getSeparadorGrupo());
                sbuffer.append(numero.substring(i + 1));
                numero = sbuffer.toString();
            }
        }
        if (meio.length() < numero.length()) {
            StringBuffer numGrande = new StringBuffer();
            for (i = 0; i < meio.length(); ++i) {
                numGrande.append('*');
            }
            numero = numGrande.toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefixo);
        buf.append(sinal);
        buf.append(numero);
        buf.append(sufixo);
        String resultado = buf.toString();
        return resultado;
    }

    public String numeroToString(String numero) throws ExcecaoDadoInvalido {
        String separadorDecimal = ".";
        int indiceSepDecimal = 0;
        String antesPonto = null;
        String depoisPonto = null;
        if (numero == null || numero.equals("")) {
            ExcecaoDadoInvalido e = new ExcecaoDadoInvalido();
            throw e;
        }
        indiceSepDecimal = numero.indexOf(".");
        if (indiceSepDecimal > 0) {
            antesPonto = numero.substring(0, indiceSepDecimal);
            depoisPonto = numero.substring(indiceSepDecimal);
        } else if (indiceSepDecimal == 0) {
            antesPonto = "0";
            depoisPonto = numero;
        } else if (indiceSepDecimal < 0) {
            antesPonto = numero;
            depoisPonto = "0";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(antesPonto);
        buf.append('.');
        buf.append(depoisPonto);
        String resultado = this.numeroToString(new CSIBigDecimal(buf.toString()));
        return resultado;
    }

    public String numeroToString(String numero, String mask) throws ExcecaoDadoInvalido {
        String zero = "0";
        int indiceSep = 0;
        String antesPonto = null;
        String depoisPonto = null;
        String mascaraAntiga = null;
        if (numero == null || numero.equals("")) {
            ExcecaoDadoInvalido e = new ExcecaoDadoInvalido();
            throw e;
        }
        if (mask == null || mask.equals("")) {
            ExcecaoDadoInvalido e = new ExcecaoDadoInvalido();
            throw e;
        }
        indiceSep = numero.indexOf(this.separadorDecimal);
        if (indiceSep > 0) {
            antesPonto = numero.substring(0, indiceSep);
            depoisPonto = numero.substring(indiceSep);
        } else if (indiceSep == 0) {
            antesPonto = "0";
            depoisPonto = numero;
        } else if (indiceSep < 0) {
            antesPonto = numero;
            depoisPonto = "0";
        }
        mascaraAntiga = this.getPadraoNumero();
        this.setPadraoNumero(mask);
        StringBuffer buf = new StringBuffer();
        buf.append(antesPonto);
        buf.append('.');
        buf.append(depoisPonto);
        String resultado = this.numeroToString(new CSIBigDecimal(buf.toString()));
        this.setPadraoNumero(mascaraAntiga);
        return resultado;
    }

    public String numeroToStringSemSeparador(CSIBigDecimal valor) {
        String sNumero = this.numeroToString(valor);
        String retorno = "";
        for (int i = 0; i < sNumero.length(); ++i) {
            if (sNumero.charAt(i) != '0' && sNumero.charAt(i) != '1' && sNumero.charAt(i) != '2' && sNumero.charAt(i) != '3' && sNumero.charAt(i) != '4' && sNumero.charAt(i) != '5' && sNumero.charAt(i) != '6' && sNumero.charAt(i) != '7' && sNumero.charAt(i) != '8' && sNumero.charAt(i) != '9') continue;
            retorno = retorno + sNumero.substring(i, i + 1);
        }
        return retorno;
    }

    public BigDecimal reduzPotenciaNum(BigDecimal num) {
        int casasDecimais = this.getNumCasasDecimal();
        BigDecimal res = num.movePointLeft(casasDecimais);
        return res;
    }

    public void setLingua(String valor) {
        this.lingua = valor;
    }

    public void setLocalidade(String loc) {
        this.localidade = loc;
    }

    public void setPadraoData(String newValue) {
        this.padraoData = newValue;
    }

    public void setPadraoHora(String newValue) {
        this.padraoHora = newValue;
    }

    public void setPadraoIntervalo(String newValue) {
        this.padraoIntervalo = newValue;
    }

    public void setPadraoNumero(String newValue) {
        this.padraoNumero = newValue;
    }

    public void setSeparadorDecimal(String newValue) {
        this.separadorDecimal = newValue;
    }

    public void setSeparadorGrupo(String newValue) {
        this.separadorGrupo = newValue;
    }

    public CSIBigDecimal stringInternacionalizadoToNumero(String numero) {
        int indice;
        String sepDecimais = this.getSeparadorDecimal();
        String sepDeGrupo = this.getSeparadorGrupo();
        String valor = numero;
        while ((indice = valor.indexOf(sepDeGrupo)) >= 0) {
            valor = valor.substring(0, indice) + valor.substring(indice + sepDeGrupo.length());
        }
        indice = valor.indexOf(sepDecimais);
        valor = valor.substring(0, indice) + "." + valor.substring(indice + sepDecimais.length());
        return new CSIBigDecimal(valor);
    }

    public CSIBigDecimal stringToNumero(String str) {
        return new CSIBigDecimal(str);
    }

    public void touch() {
        this.getChaveString();
        this.getLingua();
        this.getLocale().getLanguage();
        this.getLocale().getCountry();
        this.getLocalidade();
        this.getPadraoData();
        this.getNumCasasDecimal();
        this.getPadraoHora();
        this.getPadraoNumero();
        this.getSeparadorDecimal();
        this.getSeparadorGrupo();
    }

    public CSIBigDecimal trunca(CSIBigDecimal num) {
        int casasDecimais = this.getNumCasasDecimal();
        CSIBigDecimal d = num;
        if (num.lesser(CSIBigDecimal.getZero())) {
            d = num.negative();
        }
        CSIBigDecimal res = d.setScale(casasDecimais, 1);
        return res;
    }
}

