/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;

public class PersistService {
    private static PersistService persistService;
    private final String PERSISTENCE_FOLDER = "dat";
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;
    private ILogger logger = CTFClientLogger.getCTFClient();

    private PersistService() {
    }

    public static PersistService getInstance() {
        if (persistService == null) {
            persistService = new PersistService();
        }
        return persistService;
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    private String formatPath(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String path = "";
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/" : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
        return path + "dat" + "/";
    }

    private String formatName(String name, IdentTerminal identTerminal) throws ExcecaoApiAc {
        return this.formatPath(identTerminal) + name + ".dat";
    }

    public boolean exists(String key, IdentTerminal identTerminal) {
        try {
            String name = this.formatName(key, identTerminal);
            File file = new File(name);
            return file.exists();
        }
        catch (ExcecaoApiAc e) {
            this.logger.error(e);
            return false;
        }
    }

    public void save(String key, Object obj, IdentTerminal identTerminal) throws ExcecaoApiAc {
        String path = this.formatName(key, identTerminal);
        this.createPath(path);
        try {
            RandomAccessFile raf = new RandomAccessFile(path, "rwd");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(bos);
            output.writeObject(obj);
            byte[] buffer = bos.toByteArray();
            raf.write(buffer);
            output.close();
            bos.close();
            raf.close();
        }
        catch (Exception e) {
            this.logger.error("n\u00e3o foi poss\u00edvel gravar o arquivo de controle " + key + ".dat para o terminal " + identTerminal);
            throw new ExcecaoApiAc(null, "Erro ao gravar arquivo", "", e);
        }
    }

    public Object load(String key, IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatName(key, identTerminal);
        Object obj = null;
        try {
            ObjectInputStream input = null;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                this.logger.error("o arquivo " + key + ".dat para o terminal " + identTerminal + " est\u00e1 corrompido e ser\u00e1 deletado.");
                fileInput.close();
                File file = new File(name);
                if (file.exists()) {
                    this.logger.info(key + ".dat deletado para o terminal " + identTerminal + " " + file.delete());
                }
                throw new ExcecaoApiAc(null, "LOAD", "ARQUIVO CORROMPIDO", e);
            }
            try {
                obj = input.readObject();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("arquivo de controle " + key + ".dat carregado para terminal " + identTerminal);
                }
            }
            catch (ClassNotFoundException e) {
                input.close();
                fileInput.close();
                throw new ExcecaoApiAc("CMOS00", "LOAD", "CLASSNOTFOUND", e);
            }
            input.close();
            fileInput.close();
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("CMOS00", "ERRO", "ERRO_FILE", e);
        }
        return obj;
    }

    public Collection loadAll(IdentTerminal identTerminal) throws ExcecaoApiAc {
        ArrayList<Object> list = null;
        File file = new File(this.formatPath(identTerminal));
        if (file.exists()) {
            list = new ArrayList<Object>();
            File[] files = file.listFiles();
            int qtd = files != null ? files.length : 0;
            for (int i = 0; i < qtd; ++i) {
                File f = files[i];
                int tam = f.getName().length();
                Object dat = this.load(f.getName().substring(0, tam - 4), identTerminal);
                if (dat == null) break;
                list.add(dat);
            }
        }
        return list;
    }

    public void remove(String key, IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatName(key, identTerminal);
        File file = new File(name);
        file.delete();
    }

    public void removeAll(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String path = this.formatPath(identTerminal);
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                file.delete();
            }
        }
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists()) {
            arquivo.mkdirs();
        }
    }

    static {
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
    }
}

