/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CodGeral;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarras;

public class CalculadorDigito {
    public static final String MODULO11 = "MODULO11";
    public static final String EAN13 = "EAN13";

    public static String calculaDigito(String valor, String tipo) {
        if (tipo.equals(EAN13)) {
            CodigoBarras c = new CodigoBarras(valor);
            return c.calculaDigito(valor);
        }
        if (tipo.equals(MODULO11)) {
            try {
                CodGeral c = new CodGeral(valor);
                return c.calculaDigito(valor);
            }
            catch (Exception e) {
                return null;
            }
        }
        return "0";
    }

    public static void main(String[] args) {
    }

    public static String calculaDigitoModulo10(String codigo) throws ExcecaoCodigoInvalido {
        if (codigo == null || codigo.trim().length() == 0) {
            throw new ExcecaoCodigoInvalido();
        }
        int multiplicador = 2;
        int dvg = 0;
        for (int contador = codigo.length(); contador > 0; --contador) {
            int produtoDigito = new Integer(codigo.substring(contador - 1, contador));
            dvg += (produtoDigito *= multiplicador) % 10 + produtoDigito / 10;
            multiplicador = multiplicador % 2 + 1;
        }
        dvg = (10 - dvg % 10) % 10;
        return "" + dvg;
    }

    public static String calculaDigitoModulo11(String codigo, int posicao, int tipoConta) throws ExcecaoCodigoInvalido {
        if (codigo == null || codigo.trim().length() == 0 || posicao > codigo.trim().length()) {
            throw new ExcecaoCodigoInvalido();
        }
        String codigoSemDigito = codigo.substring(0, posicao - 1) + codigo.substring(posicao, codigo.length());
        return CalculadorDigito.calculaDigitoModulo11Bloco(codigoSemDigito, tipoConta);
    }

    public static void validaDigitoModulo11(String codigo, int posicao, int tipoConta) throws ExcecaoCodigoInvalido, ExcecaoDigitoInvalido {
        if (codigo == null || codigo.trim().length() == 0 || posicao > codigo.trim().length()) {
            throw new ExcecaoCodigoInvalido();
        }
        String digitoLido = codigo.substring(posicao - 1, posicao);
        String digitoCalculado = CalculadorDigito.calculaDigitoModulo11(codigo, posicao, tipoConta);
        if (!digitoCalculado.equals(digitoLido)) {
            throw new ExcecaoDigitoInvalido();
        }
    }

    public static void validaModulo10(String codigo) throws ExcecaoDigitoInvalido {
        if (codigo == null || codigo.trim().length() == 0) {
            throw new ExcecaoDigitoInvalido();
        }
        int posInicio = 0;
        String bloco = "";
        String digito = "";
        String digitoCalculado = "";
        for (int i = 1; i < 5; ++i) {
            bloco = codigo.substring(posInicio, posInicio + 12);
            digito = bloco.substring(bloco.length() - 1, bloco.length());
            try {
                digitoCalculado = CalculadorDigito.calculaDigitoModulo10(bloco.substring(0, bloco.length() - 1));
            }
            catch (ExcecaoCodigoInvalido e) {
                e.printStackTrace();
            }
            if (!digito.equals(digitoCalculado)) {
                throw new ExcecaoDigitoInvalido();
            }
            posInicio += 12;
        }
    }

    public static String calculaDigitoModulo11Geral(String codigoSemDigito) throws ExcecaoCodigoInvalido {
        if (codigoSemDigito == null || codigoSemDigito.trim().length() == 0) {
            throw new ExcecaoCodigoInvalido();
        }
        int multiplicador = 2;
        int digitoCalculado = 0;
        try {
            for (int contador = codigoSemDigito.length(); contador > 0; --contador) {
                int produtoDigito = new Integer(codigoSemDigito.substring(contador - 1, contador));
                digitoCalculado += (produtoDigito *= multiplicador);
                if (multiplicador == 9) {
                    multiplicador = 2;
                    continue;
                }
                ++multiplicador;
            }
            if ((digitoCalculado = 11 - digitoCalculado % 11) >= 10 || digitoCalculado == 0) {
                digitoCalculado = 0;
            }
        }
        catch (NumberFormatException e) {
            throw new ExcecaoCodigoInvalido();
        }
        return "" + digitoCalculado;
    }

    public static String calculaDigitoModulo11Bloco(String codigoSemDigito, int tipoConta) throws ExcecaoCodigoInvalido {
        int digitoCalculado;
        block13: {
            if (codigoSemDigito == null || codigoSemDigito.trim().length() == 0) {
                throw new ExcecaoCodigoInvalido();
            }
            int multiplicador = 2;
            digitoCalculado = 0;
            try {
                for (int contador = codigoSemDigito.length(); contador > 0; --contador) {
                    int produtoDigito = new Integer(codigoSemDigito.substring(contador - 1, contador));
                    digitoCalculado += (produtoDigito *= multiplicador);
                    if (multiplicador == 9) {
                        multiplicador = 2;
                        continue;
                    }
                    ++multiplicador;
                }
                if (tipoConta == 1) {
                    if ((digitoCalculado = 11 - digitoCalculado % 11) >= 10 || digitoCalculado == 0) {
                        digitoCalculado = 1;
                    }
                    break block13;
                }
                if (tipoConta == 2) {
                    if ((digitoCalculado %= 11) == 0 || digitoCalculado == 1) {
                        digitoCalculado = 0;
                    } else if (digitoCalculado == 10) {
                        digitoCalculado = 1;
                    } else if (digitoCalculado > 1) {
                        digitoCalculado = 11 - digitoCalculado;
                    }
                    break block13;
                }
                throw new IllegalArgumentException("Utilizar CodigoBarrasUtil.VALIDAR_TITULO ou CodigoBarrasUtil.VALIDAR_CONVENIO");
            }
            catch (NumberFormatException e) {
                throw new ExcecaoCodigoInvalido();
            }
        }
        return "" + digitoCalculado;
    }

    public static void validaLinhaDigitavel(String linhaDigitavel) throws ExcecaoCodigoInvalido {
        if (linhaDigitavel.length() > 47) {
            throw new ExcecaoCodigoInvalido();
        }
        linhaDigitavel = StringUtil.completaString(linhaDigitavel, 47, '0', false);
        String campo1 = linhaDigitavel.substring(0, 9);
        String campo2 = linhaDigitavel.substring(10, 20);
        String campo3 = linhaDigitavel.substring(21, 31);
        String campo4 = linhaDigitavel.substring(33, linhaDigitavel.length());
        String codigoBarras = campo1.substring(0, 4);
        codigoBarras = codigoBarras + campo4;
        codigoBarras = codigoBarras + linhaDigitavel.substring(4, campo1.length());
        codigoBarras = codigoBarras + campo2;
        codigoBarras = codigoBarras + campo3;
        String digitoBarras = CalculadorDigito.calculaDigitoModulo11Bloco(codigoBarras, 1);
        if (!(digitoBarras.equals(linhaDigitavel.substring(32, 33)) && linhaDigitavel.substring(9, 10).equals(CalculadorDigito.calculaDigitoModulo10(campo1)) && linhaDigitavel.substring(20, 21).equals(CalculadorDigito.calculaDigitoModulo10(campo2)) && linhaDigitavel.substring(31, 32).equals(CalculadorDigito.calculaDigitoModulo10(campo3)))) {
            throw new ExcecaoCodigoInvalido();
        }
    }
}

