/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.info.tiposgerais.Chave;
import com.csi.ctfclient.tools.util.Procedimentos;
import java.io.Serializable;

public abstract class Codigo
extends Chave
implements Serializable {
    protected String codigo;
    protected String digitoVerificador;
    private static final String MENSAGEM1 = "ID02";
    private static final String MENSAGEM2 = "ID01";
    private static final String MENSAGEM3 = "ID03";

    protected Codigo() {
    }

    public Codigo(String codigo) throws ExcecaoCodigoInvalido, ExcecaoDigitoInvalido {
        this.setCodigo(codigo);
    }

    public Codigo(String codigo, String digito) throws ExcecaoCodigoInvalido, ExcecaoDigitoInvalido {
        this.setCodigo(codigo);
        this.setDigitoVerificador(digito);
        if (!this.validaDigito()) {
            throw new ExcecaoCodigoInvalido(MENSAGEM1);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Codigo)) {
            return false;
        }
        Codigo c = (Codigo)obj;
        return Procedimentos.compara(this.getCodigo(), c.getCodigo()) && Procedimentos.compara(this.getDigitoVerificador(), c.getDigitoVerificador());
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDigitoVerificador() {
        return this.digitoVerificador;
    }

    protected void setCodigo(String codigo) throws ExcecaoCodigoInvalido {
        this.codigo = codigo;
        if (codigo == null || codigo.equals("")) {
            throw new ExcecaoCodigoInvalido(MENSAGEM2);
        }
    }

    protected void setDigitoVerificador(String digito) throws ExcecaoDigitoInvalido {
        this.digitoVerificador = digito;
        if (digito == null || digito.equals("")) {
            throw new ExcecaoDigitoInvalido(MENSAGEM3);
        }
    }

    @Override
    public String toString() {
        return this.codigo + this.digitoVerificador;
    }

    protected abstract boolean validaDigito();
}

