/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import com.csi.ctfclient.info.tiposgerais.ChaveString;

public class CodigoBarras {
    private String codigo;

    public CodigoBarras(String codigo) {
        this.codigo = codigo;
    }

    public String calculaDigito(String codigo) {
        int soma = 0;
        int m = 3;
        for (int i = codigo.length() - 1; i >= 0; --i) {
            soma += new Integer(new Character(codigo.charAt(i)).toString()) * m;
            if (m == 3) {
                m = 1;
                continue;
            }
            if (m != 1) continue;
            m = 3;
        }
        int somaT = soma;
        while (somaT % 10 != 0) {
            ++somaT;
        }
        return new Integer(somaT - soma).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodigoBarras)) {
            return false;
        }
        return this.codigo.equals(obj.toString());
    }

    public ChaveString getChave() {
        return new ChaveString(this.codigo);
    }

    protected String getCodigo() {
        return this.codigo;
    }

    public static void main(String[] argv) {
        CodigoBarras cod = new CodigoBarras("7894650152072");
        System.out.println("O digito calculado: " + cod.calculaDigito("789465015207"));
        System.out.println("Validacao: " + cod.validaDigito());
    }

    public String toString() {
        return this.codigo;
    }

    public boolean validaDigito() {
        return this.validaDigito(this.codigo);
    }

    public boolean validaDigito(String codigo) {
        int soma = 0;
        int m = 3;
        for (int i = codigo.length() - 2; i >= 0; --i) {
            soma += new Integer(new Character(codigo.charAt(i)).toString()) * m;
            if (m == 3) {
                m = 1;
                continue;
            }
            if (m != 1) continue;
            m = 3;
        }
        int somaT = soma;
        while (somaT % 10 != 0) {
            ++somaT;
        }
        return somaT - soma == new Integer(new Character(codigo.charAt(codigo.length() - 1)).toString());
    }
}

