/** 
 (C) Copyright IBM Corporation 2006
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 sample code created by IBM Corporation. This sample code is not
 part of any standard or IBM product and is provided to you solely
 for  the purpose of assisting you in the development of your
 applications.  The code is provided "AS IS", without
 warranty of any kind.  IBM shall not be liable for any damages
 arising out of your use of the sample code, even if they have been
 advised of the possibility of such damages.
 */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.MotionSensor;
import jpos.MotionSensorConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * MotionSensorDemo class implements a demo 
 * for the basic functionality of the MotionSensor
 * 
 * */
public class MotionSensorDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try MotionSensorDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n" +
            "java com.ibm.jpos.tools.sdicc.demo.MotionSensorDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.MotionSensor functionality
        DeviceDemo devDemo = new MotionSensorDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("MotionSensorDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700,400);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);
    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_START_DEVICE },
        { TOOLTIP_TEXT_DEVICE_START } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "MotionSensor";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_START_DEVICE))
        {
            // start the device test
            doStartDeviceTest();
            ui.flipButtonLabel(TEXT_START_DEVICE, 
                    new String[]{TEXT_STOP_DEVICE,TOOLTIP_TEXT_DEVICE_STOP});
        }else if ( button.equals(TEXT_STOP_DEVICE ))
        {
            ui.flipButtonLabel(TEXT_STOP_DEVICE,
                    new String[]{TEXT_START_DEVICE,TOOLTIP_TEXT_DEVICE_START});
            doStopDeviceTest();
        }
    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e  the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred = ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;
            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;
            case MotionSensorConst.MOTION_M_ABSENT:
                statusMsg += "MOTION_M_ABSENT";
                break;
            case MotionSensorConst.MOTION_M_PRESENT:
                statusMsg += "MOTION_M_PRESENT";
                break;
            default:
                statusMsg+= status;
        }
        //display the status update received
        ui.displayText(statusMsg);
    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the MotionSensor
     * */
    protected void doStartDeviceTest() throws JposException
    {
        ms.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try{
            // Common Properties
            ui.displayText("DeviceControlVersion = "
                    + ms.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + ms.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + ms.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + ms.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = " + 
                    ms.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch(ms.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = "+ capPowerReportingName + 
                    ms.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = " + 
                    ms.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " + ms.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = " + 
                    ms.getCapUpdateStatistics());
            ms.addStatusUpdateListener(this);
            ui.displayText("addStatusUpdateListener(this)");
            if( ms.getCapPowerReporting() != JposConst.JPOS_PR_NONE)
            {
                ms.setPowerNotify(JposConst.JPOS_PN_ENABLED);
                ui.displayText("PowerNotify = JPOS_PN_ENABLED");
            }
            
            ms.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            // Specific Properties
            ui.displayText("Motion Property = "+ ms.getMotion());
            ui.displayText("Timeout Property = "+ ms.getTimeout());
            ui.displayText("#\n# Move your hand in front of the motion sensor area...\n#");
        }
        catch(JposException je)
        {
            doStopDeviceTest();
            throw je;
        }
    }
    
    protected void doStopDeviceTest() throws JposException
    {
        ms.removeStatusUpdateListener(this);
        ui.displayText("removeStatusUpdateListener(this)");
        ms.close();
        ui.displayText("close()");
    }
    //-------------------------------------------------------------------------
    // instance variables
    //
    private MotionSensor ms = new MotionSensor();
    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_START_DEVICE="Start Motion Sensor Test";
    public static final String TEXT_STOP_DEVICE="Stop Motion  Sensor Test";


    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_DEVICE_START = 
        "Open, enable and register a listener in the Motion Sensor to detect" +
        " the presence of persons";
    
    /** tool tip text for Stop button */
    private static final String TOOLTIP_TEXT_DEVICE_STOP = 
        "Unregister the listener and closes the Motion Sensor";
}
